/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class Mappings {
    private static final Map<String, Entry> MAPPINGS = new HashMap<String, Entry>();
    private static boolean loaded = false;

    public static void load(File configFolder) {
        File[] files;
        if (loaded) {
            return;
        }
        Mappings.loadInternalMapping("defender_game_racer_x7");
        File folder = new File(configFolder, "controllable/mappings");
        if (folder.mkdirs()) {
            Controllable.LOGGER.info("Successfully created Controllable config folder");
        }
        if ((files = folder.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                Mappings.loadMapping(file);
            }
        }
        Mappings.initProperties();
        loaded = true;
    }

    private static void initProperties() {
        boolean changed = false;
        Controller controller = Controllable.getController();
        if (controller != null) {
            String selectedMapping;
            String lastController = ControllerProperties.getLastController();
            boolean sameController = controller.getName().equals(lastController);
            if (lastController.trim().isEmpty() || !sameController) {
                ControllerProperties.setLastController(controller.getName());
                changed = true;
            }
            if ((selectedMapping = ControllerProperties.getSelectedMapping()).trim().isEmpty() || !sameController) {
                String mapping = controller.getName();
                Entry entry = MAPPINGS.get(mapping);
                controller.setMapping(entry);
                if (entry != null) {
                    ControllerProperties.setSelectedMapping(mapping);
                }
                changed = true;
            } else {
                Entry entry = MAPPINGS.get(selectedMapping);
                controller.setMapping(entry);
            }
        }
        if (changed) {
            ControllerProperties.save();
        }
    }

    private static void loadInternalMapping(String mappingName) {
        try (InputStreamReader reader = new InputStreamReader(Mappings.class.getResourceAsStream("/mappings/" + mappingName + ".json"));){
            Mappings.loadMapping(reader).internal = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadMapping(File file) {
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(file));){
            Mappings.loadMapping(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Entry loadMapping(Reader reader) {
        JsonElement element = new JsonParser().parse(reader);
        String id = element.getAsJsonObject().get("id").getAsString();
        String name = element.getAsJsonObject().get("name").getAsString();
        HashMap<Integer, Integer> reassignments = new HashMap<Integer, Integer>();
        if (element.getAsJsonObject().has("reassign")) {
            JsonArray array = element.getAsJsonObject().get("reassign").getAsJsonArray();
            array.forEach(jsonElement -> {
                int index = jsonElement.getAsJsonObject().get("index").getAsInt();
                int with = jsonElement.getAsJsonObject().get("with").getAsInt();
                reassignments.put(index, with);
            });
        }
        Entry entry = new Entry(id, name, reassignments);
        MAPPINGS.put(id, entry);
        return entry;
    }

    public static void updateControllerMappings(Controller controller) {
        controller.setMapping(MAPPINGS.get(controller.getName()));
    }

    static {
        MAPPINGS.put("Default", null);
    }

    public static class Entry {
        private String id;
        private String name;
        private BiMap<Integer, Integer> reassignments;
        private boolean internal;

        public Entry(String id, String name, Map<Integer, Integer> reassignments) {
            this.id = id;
            this.name = name;
            this.reassignments = HashBiMap.create(reassignments);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public BiMap<Integer, Integer> getReassignments() {
            return this.reassignments;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public int remap(int button) {
            Integer value = (Integer)this.reassignments.get((Object)button);
            if (value != null) {
                return value;
            }
            return button;
        }

        public void save() {
            try {
                File mappingsFolder = new File(Minecraft.func_71410_x().field_71412_D, "config/controllable/mappings");
                mappingsFolder.mkdirs();
                String name = this.id.replaceAll("\\s+", "_").toLowerCase(Locale.ENGLISH) + ".json";
                GsonBuilder builder = new GsonBuilder();
                builder.registerTypeAdapter(Entry.class, (Object)new Serializer());
                Gson gson = builder.create();
                String json = gson.toJson((Object)this);
                FileOutputStream fos = new FileOutputStream(new File(mappingsFolder, name));
                fos.write(json.getBytes());
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public static class Serializer
        implements JsonSerializer<Entry> {
            public JsonElement serialize(Entry src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject object = new JsonObject();
                object.addProperty("id", src.id);
                object.addProperty("name", src.name);
                JsonArray array = new JsonArray();
                src.reassignments.forEach((index, with) -> {
                    JsonObject entry = new JsonObject();
                    entry.addProperty("index", (Number)index);
                    entry.addProperty("with", (Number)with);
                    array.add((JsonElement)entry);
                });
                object.add("reassign", (JsonElement)array);
                return object;
            }
        }
    }
}

