/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.ControllerList;
import com.mrcrayfish.controllable.client.gui.SettingsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import uk.co.electronstudio.sdl2gdx.SDL2ControllerManager;

public class ControllerSelectionScreen
extends Screen {
    private int controllerCount;
    private SDL2ControllerManager manager;
    private ControllerList listControllers;
    private Screen previousScreen;
    private Button btnSettings;
    private Button btnRemap;
    private Button btnBack;

    public ControllerSelectionScreen(SDL2ControllerManager manager, Screen previousScreen) {
        super((ITextComponent)new TranslationTextComponent("controllable.selectController.title", new Object[0]));
        this.manager = manager;
        this.previousScreen = previousScreen;
        this.controllerCount = manager.getControllers().size;
    }

    protected void init() {
        this.listControllers = new ControllerList(this.manager, this.minecraft, this.width, this.height, 32, this.height - 44, 20);
        this.children.add(this.listControllers);
        this.btnSettings = (Button)this.addButton((Widget)new Button(this.width / 2 - 154, this.height - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.settings", (Object[])new Object[0]), this::handleSettings));
        this.btnRemap = (Button)this.addButton((Widget)new Button(this.width / 2 - 50, this.height - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.remap", (Object[])new Object[0]), this::handleConfigure));
        this.btnBack = (Button)this.addButton((Widget)new Button(this.width / 2 + 54, this.height - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.back", (Object[])new Object[0]), this::handleCancel));
        this.btnRemap.active = false;
    }

    public void tick() {
        if (this.controllerCount != this.manager.getControllers().size) {
            this.controllerCount = this.manager.getControllers().size;
            this.listControllers.reload();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.listControllers.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"controllable.gui.title.select_controller", (Object[])new Object[0]), this.width / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }

    private void handleSettings(Button button) {
        this.minecraft.func_147108_a((Screen)new SettingsScreen(this));
    }

    private void handleConfigure(Button button) {
        this.minecraft.func_147108_a((Screen)new ControllerLayoutScreen(this));
    }

    private void handleCancel(Button button) {
        this.minecraft.func_147108_a(this.previousScreen);
    }
}

