/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.sdl2gdx;

import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import org.libsdl.SDL;
import org.libsdl.SDL_Error;
import org.libsdl.SDL_GameController;
import org.libsdl.SDL_Joystick;
import uk.co.electronstudio.sdl2gdx.RumbleController;
import uk.co.electronstudio.sdl2gdx.SDL2ControllerManager;

public class SDL2Controller
implements RumbleController {
    final SDL2ControllerManager manager;
    final Array<ControllerListener> listeners = new Array();
    final int device_index;
    public final SDL_Joystick joystick;
    final SDL_GameController controller;
    final float[] axisState;
    final boolean[] buttonState;
    final PovDirection[] hatState;
    static final Vector3 zero = new Vector3(0.0f, 0.0f, 0.0f);

    public SDL2Controller(SDL2ControllerManager manager, int device_index) throws SDL_Error {
        this.manager = manager;
        this.device_index = device_index;
        this.joystick = SDL_Joystick.JoystickOpen(device_index);
        this.hatState = new PovDirection[this.joystick.numHats()];
        if (SDL.SDL_IsGameController(device_index)) {
            this.controller = SDL_GameController.GameControllerOpen(device_index);
            this.buttonState = new boolean[15];
            this.axisState = new float[6];
        } else {
            this.controller = null;
            this.buttonState = new boolean[this.joystick.numButtons()];
            this.axisState = new float[this.joystick.numAxes()];
        }
        System.out.println("joystick " + this.joystick + " controller " + this.controller);
        if (this.joystick == null && this.controller == null) {
            throw new SDL_Error();
        }
    }

    public boolean isConnected() {
        return this.joystick.getAttached();
    }

    void pollState() throws SDL_Error {
        int i;
        for (i = 0; i < this.axisState.length; ++i) {
            if (this.axisState[i] != this.getAxis(i)) {
                for (ControllerListener listener : this.listeners) {
                    listener.axisMoved(this, i, this.getAxis(i));
                }
                this.manager.axisChanged(this, i, this.getAxis(i));
            }
            this.axisState[i] = this.getAxis(i);
        }
        for (i = 0; i < this.buttonState.length; ++i) {
            if (this.buttonState[i] != this.getButton(i)) {
                for (ControllerListener listener : this.listeners) {
                    if (this.getButton(i)) {
                        listener.buttonDown(this, i);
                        continue;
                    }
                    listener.buttonUp(this, i);
                }
                this.manager.buttonChanged(this, i, this.getButton(i));
            }
            this.buttonState[i] = this.getButton(i);
        }
        for (i = 0; i < this.hatState.length; ++i) {
            if (this.hatState[i] == this.getPov(i)) continue;
            this.hatState[i] = this.getPov(i);
            for (ControllerListener listener : this.listeners) {
                listener.povMoved(this, i, this.getPov(i));
            }
            this.manager.hatChanged(this, i, this.getPov(i));
        }
    }

    @Override
    public void addListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ControllerListener listener) {
        this.listeners.removeValue(listener, true);
    }

    @Override
    public boolean getButton(int buttonCode) {
        if (this.controller != null) {
            return this.controller.getButton(buttonCode);
        }
        return this.joystick.getButton(buttonCode);
    }

    @Override
    public float getAxis(int axisCode) {
        if (this.controller != null) {
            return this.controller.getAxis(axisCode);
        }
        return this.joystick.getAxis(axisCode);
    }

    @Override
    public PovDirection getPov(int povCode) {
        if (this.controller != null) {
            if (this.buttonState[11] && this.buttonState[14]) {
                return PovDirection.northEast;
            }
            if (this.buttonState[11] && this.buttonState[13]) {
                return PovDirection.northWest;
            }
            if (this.buttonState[12] && this.buttonState[14]) {
                return PovDirection.southEast;
            }
            if (this.buttonState[12] && this.buttonState[13]) {
                return PovDirection.southWest;
            }
            if (this.buttonState[11]) {
                return PovDirection.north;
            }
            if (this.buttonState[14]) {
                return PovDirection.east;
            }
            if (this.buttonState[12]) {
                return PovDirection.south;
            }
            if (this.buttonState[13]) {
                return PovDirection.west;
            }
            return PovDirection.center;
        }
        if (this.joystick != null) {
            switch (this.joystick.getHat(povCode)) {
                case 1: {
                    return PovDirection.north;
                }
                case 4: {
                    return PovDirection.south;
                }
                case 2: {
                    return PovDirection.east;
                }
                case 8: {
                    return PovDirection.west;
                }
                case 3: {
                    return PovDirection.northEast;
                }
                case 6: {
                    return PovDirection.southEast;
                }
                case 9: {
                    return PovDirection.northWest;
                }
                case 12: {
                    return PovDirection.southWest;
                }
            }
            return PovDirection.center;
        }
        return PovDirection.center;
    }

    @Override
    public boolean getSliderX(int sliderCode) {
        return false;
    }

    @Override
    public boolean getSliderY(int sliderCode) {
        return false;
    }

    @Override
    public Vector3 getAccelerometer(int accelerometerCode) {
        return zero;
    }

    @Override
    public void setAccelerometerSensitivity(float sensitivity) {
    }

    @Override
    public String getName() {
        if (this.controller != null) {
            return "SDL GameController " + this.controller.name();
        }
        return "SDL Joystick " + this.joystick.name();
    }

    public String toString() {
        return this.getName() + " instance:" + this.joystick.instanceID() + "  guid: " + this.joystick.GUID() + " v " + SDL_Joystick.productVersion(this.device_index);
    }

    public void close() {
        this.joystick.close();
        if (this.controller != null) {
            this.controller.close();
        }
    }

    @Override
    public boolean rumble(float leftMagnitude, float rightMagnitude, int duration_ms) {
        return this.joystick.rumble(leftMagnitude, rightMagnitude, duration_ms);
    }
}

