/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.sdl2gdx.tests;

import com.badlogic.gdx.controllers.Controller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import org.libsdl.SDL;
import org.libsdl.SDL_Error;
import uk.co.electronstudio.sdl2gdx.SDL2Controller;
import uk.co.electronstudio.sdl2gdx.SDL2ControllerManager;

public class SDLTest {
    public static int NUM_CONTROLLERS = 5;
    public static SDL2ControllerManager controllerManager;
    public static volatile boolean requestRestart;
    static JCheckBox xinput;

    public static void main(String[] args) {
        SDLTest.init();
        JTabbedPane tabbedPane = new JTabbedPane();
        JFrame testFrame = new JFrame();
        SDLInfoPanel[] controllerTabs = SDLTest.setup(tabbedPane, testFrame);
        while (true) {
            SDLTest.mainLoop(testFrame, controllerTabs);
        }
    }

    private static void init() {
        if (xinput.isSelected()) {
            SDL.SDL_SetHint("SDL_XINPUT_ENABLED", "1");
        } else {
            SDL.SDL_SetHint("SDL_XINPUT_ENABLED", "0");
        }
        controllerManager = new SDL2ControllerManager();
    }

    private static void mainLoop(JFrame testFrame, SDLInfoPanel[] controllerTabs) {
        if (requestRestart) {
            controllerManager.close();
            SDLTest.init();
            requestRestart = false;
        }
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            controllerManager.pollState();
        }
        catch (SDL_Error sdl_error) {
            sdl_error.printStackTrace();
        }
        for (int i = 0; i < SDLTest.controllerManager.getControllers().size; ++i) {
            Controller controllerAtIndex = controllerManager.getControllers().get(i);
            controllerTabs[i].updatePanel((SDL2Controller)controllerAtIndex);
        }
        testFrame.repaint();
    }

    private static SDLInfoPanel[] setup(JTabbedPane tabbedPane, JFrame testFrame) {
        testFrame.setDefaultCloseOperation(3);
        testFrame.setLocationRelativeTo(null);
        testFrame.setMinimumSize(new Dimension(1000, 350));
        testFrame.setResizable(true);
        testFrame.setVisible(true);
        SDLInfoPanel[] controllerTabs = new SDLInfoPanel[NUM_CONTROLLERS];
        for (int i = 0; i < NUM_CONTROLLERS; ++i) {
            controllerTabs[i] = new SDLInfoPanel();
            tabbedPane.add("   Controller " + (i + 1) + "   ", controllerTabs[i]);
        }
        tabbedPane.add("Options", new OptionPanel());
        testFrame.setContentPane(tabbedPane);
        return controllerTabs;
    }

    private static void rumbleExample(SDL2ControllerManager controllerManager) {
        SDL2Controller controller = (SDL2Controller)controllerManager.getControllers().get(0);
        controller.rumble(1.0f, 1.0f, 500);
    }

    private static void reflectionExample(SDL2ControllerManager controllerManager) {
        Method method = null;
        Controller controller = controllerManager.getControllers().get(0);
        for (Method m : controller.getClass().getMethods()) {
            if (!m.getName().equals("rumble")) continue;
            method = m;
        }
        try {
            method.invoke((Object)controller, Float.valueOf(1.0f), Float.valueOf(1.0f), 500);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        requestRestart = false;
        xinput = new JCheckBox("XInput enable");
    }

    public static class OptionPanel
    extends JPanel {
        private JPanel title;
        private JButton restartButton;
        private JLabel titleLabel;

        public OptionPanel() {
            this.setLayout(new BorderLayout());
            this.title = new JPanel();
            JPanel panel = new JPanel();
            this.restartButton = new JButton("Restart SDL");
            this.restartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    requestRestart = true;
                }
            });
            panel.add(this.restartButton);
            panel.add(xinput);
            this.title.setLayout(new BoxLayout(this.title, 1));
            this.title.setAlignmentX(0.5f);
            this.titleLabel = new JLabel();
            this.title.add(this.titleLabel);
            JPanel middlePanel = new JPanel();
            middlePanel.setLayout(new BoxLayout(middlePanel, 1));
            middlePanel.add(this.title);
            this.add(middlePanel);
            this.add((Component)panel, "South");
        }
    }

    public static class SDLInfoPanel
    extends JPanel {
        private JPanel title;
        private JPanel axes;
        private JPanel buttons;
        private JPanel pov;
        private JSlider leftRumble;
        private JSlider rightRumble;
        private JButton vibrateButton;
        private JLabel titleLabel;

        public SDLInfoPanel() {
            this.setLayout(new BorderLayout());
            this.title = new JPanel();
            this.axes = new JPanel();
            this.buttons = new JPanel();
            this.pov = new JPanel();
            JPanel vibratePanel = new JPanel();
            this.vibrateButton = new JButton("Rumble");
            this.leftRumble = new JSlider(0, 100, 100);
            this.rightRumble = new JSlider(0, 100, 100);
            vibratePanel.add(this.leftRumble);
            vibratePanel.add(this.rightRumble);
            vibratePanel.add(this.vibrateButton);
            this.title.setLayout(new BoxLayout(this.title, 1));
            this.title.setAlignmentX(0.5f);
            this.titleLabel = new JLabel();
            this.title.add(this.titleLabel);
            JPanel middlePanel = new JPanel();
            middlePanel.setLayout(new BoxLayout(middlePanel, 1));
            middlePanel.add(this.title);
            middlePanel.add(this.axes);
            middlePanel.add(this.pov);
            middlePanel.add(this.buttons);
            this.add(middlePanel);
            this.add((Component)vibratePanel, "South");
        }

        public void updatePanel(SDL2Controller c) {
            try {
                int i;
                this.titleLabel.setText(c.getName());
                this.axes.removeAll();
                for (i = 0; i < c.joystick.numAxes(); ++i) {
                    JLabel label = new JLabel();
                    label.setPreferredSize(new Dimension(100, 30));
                    label.setText(SDL.SDL_GameControllerGetStringForAxis(i));
                    JProgressBar progressBar = new JProgressBar(-100, 100);
                    progressBar.setPreferredSize(new Dimension(200, 30));
                    progressBar.setValue((int)(c.getAxis(i) * 100.0f));
                    JPanel axisPanel = new JPanel();
                    axisPanel.setLayout(new BoxLayout(axisPanel, 0));
                    axisPanel.add(label);
                    axisPanel.add(progressBar);
                    this.axes.add(axisPanel);
                }
                this.buttons.removeAll();
                for (i = 0; i < c.joystick.numButtons(); ++i) {
                    JButton button = new JButton(SDL.SDL_GameControllerGetStringForButton(i));
                    button.setEnabled(c.getButton(i));
                    this.buttons.add(button);
                }
                Arrays.stream(this.vibrateButton.getActionListeners()).forEach(this.vibrateButton::removeActionListener);
                this.vibrateButton.addActionListener(event -> c.rumble((float)this.leftRumble.getValue() / 100.0f, (float)this.rightRumble.getValue() / 100.0f, 1000));
                this.pov.removeAll();
                this.pov.add(new JLabel(c.getPov(0).toString()));
            }
            catch (SDL_Error e) {
                e.printStackTrace();
                this.titleLabel.setText("SDL error occurred!");
                this.axes.removeAll();
                this.buttons.removeAll();
                this.axes.add(new JLabel(e.getMessage()));
            }
        }

        public void setAsDisconnected() {
            this.titleLabel.setText("No controller connected at this index!");
            this.axes.removeAll();
            this.buttons.removeAll();
        }
    }
}

