/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class FileDescriptor {
    protected File file;
    protected FileType type;

    protected FileDescriptor() {
    }

    public FileDescriptor(String fileName) {
        this.file = new File(fileName);
        this.type = FileType.Absolute;
    }

    public FileDescriptor(File file) {
        this.file = file;
        this.type = FileType.Absolute;
    }

    protected FileDescriptor(String fileName, FileType type) {
        this.type = type;
        this.file = new File(fileName);
    }

    protected FileDescriptor(File file, FileType type) {
        this.file = file;
        this.type = type;
    }

    public String path() {
        return this.file.getPath().replace('\\', '/');
    }

    public String name() {
        return this.file.getName();
    }

    public String extension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    public String nameWithoutExtension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public FileType type() {
        return this.type;
    }

    public File file() {
        return this.file;
    }

    public InputStream read() {
        if (this.type == FileType.Classpath && !this.file.exists()) {
            InputStream input = FileDescriptor.class.getResourceAsStream("/" + this.file.getPath().replace('\\', '/'));
            if (input == null) {
                throw new RuntimeException("File not found: " + this.file + " (" + (Object)((Object)this.type) + ")");
            }
            return input;
        }
        try {
            return new FileInputStream(this.file());
        }
        catch (FileNotFoundException ex) {
            if (this.file().isDirectory()) {
                throw new RuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new RuntimeException("Error reading file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public Reader reader() {
        return new InputStreamReader(this.read());
    }

    public Reader reader(String charset) {
        try {
            return new InputStreamReader(this.read(), charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Error reading file: " + this, ex);
        }
    }

    public BufferedReader reader(int bufferSize) {
        return new BufferedReader(new InputStreamReader(this.read()), bufferSize);
    }

    public BufferedReader reader(int bufferSize, String charset) {
        try {
            return new BufferedReader(new InputStreamReader(this.read(), charset), bufferSize);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Error reading file: " + this, ex);
        }
    }

    public String readString() {
        return this.readString(null);
    }

    public String readString(String charset) {
        StringBuilder output = new StringBuilder(512);
        InputStreamReader reader = null;
        try {
            int length;
            reader = charset == null ? new InputStreamReader(this.read()) : new InputStreamReader(this.read(), charset);
            char[] buffer = new char[256];
            while ((length = reader.read(buffer)) != -1) {
                output.append(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading layout file: " + this, ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return output.toString();
    }

    public byte[] readBytes() {
        int length = (int)this.length();
        if (length == 0) {
            length = 512;
        }
        byte[] buffer = new byte[length];
        int position = 0;
        InputStream input = this.read();
        try {
            int count;
            while ((count = input.read(buffer, position, buffer.length - position)) != -1) {
                if ((position += count) != buffer.length) continue;
                byte[] newBuffer = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, position);
                buffer = newBuffer;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading file: " + this, ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (position < buffer.length) {
            byte[] newBuffer = new byte[position];
            System.arraycopy(buffer, 0, newBuffer, 0, position);
            buffer = newBuffer;
        }
        return buffer;
    }

    public int readBytes(byte[] bytes, int offset, int size) {
        InputStream input = this.read();
        int position = 0;
        try {
            int count;
            while ((count = input.read(bytes, offset + position, size - position)) > 0) {
                position += count;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading file: " + this, ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return position - offset;
    }

    public OutputStream write(boolean append) {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot write to a classpath file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            return new FileOutputStream(this.file(), append);
        }
        catch (FileNotFoundException ex) {
            if (this.file().isDirectory()) {
                throw new RuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new RuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public void write(InputStream input, boolean append) {
        OutputStream output = null;
        try {
            int length;
            output = this.write(append);
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stream writing to file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Writer writer(boolean append) {
        return this.writer(append, null);
    }

    public Writer writer(boolean append, String charset) {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot write to a classpath file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            FileOutputStream output = new FileOutputStream(this.file(), append);
            if (charset == null) {
                return new OutputStreamWriter(output);
            }
            return new OutputStreamWriter((OutputStream)output, charset);
        }
        catch (IOException ex) {
            if (this.file().isDirectory()) {
                throw new RuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new RuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public void writeString(String string, boolean append) {
        this.writeString(string, append, null);
    }

    public void writeString(String string, boolean append, String charset) {
        Writer writer = null;
        try {
            writer = this.writer(append, charset);
            writer.write(string);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void writeBytes(byte[] bytes, boolean append) {
        OutputStream output = this.write(append);
        try {
            output.write(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public FileDescriptor[] list() {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] relativePaths = this.file().list();
        if (relativePaths == null) {
            return new FileDescriptor[0];
        }
        FileDescriptor[] handles = new FileDescriptor[relativePaths.length];
        int n = relativePaths.length;
        for (int i = 0; i < n; ++i) {
            handles[i] = this.child(relativePaths[i]);
        }
        return handles;
    }

    public FileDescriptor[] list(String suffix) {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] relativePaths = this.file().list();
        if (relativePaths == null) {
            return new FileDescriptor[0];
        }
        FileDescriptor[] handles = new FileDescriptor[relativePaths.length];
        int count = 0;
        int n = relativePaths.length;
        for (int i = 0; i < n; ++i) {
            String path = relativePaths[i];
            if (!path.endsWith(suffix)) continue;
            handles[count] = this.child(path);
            ++count;
        }
        if (count < relativePaths.length) {
            FileDescriptor[] newHandles = new FileDescriptor[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    public boolean isDirectory() {
        if (this.type == FileType.Classpath) {
            return false;
        }
        return this.file().isDirectory();
    }

    public FileDescriptor child(String name) {
        if (this.file.getPath().length() == 0) {
            return new FileDescriptor(new File(name), this.type);
        }
        return new FileDescriptor(new File(this.file, name), this.type);
    }

    public FileDescriptor parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == FileType.Absolute ? new File("/") : new File("");
        }
        return new FileDescriptor(parent, this.type);
    }

    public boolean mkdirs() {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot mkdirs with a classpath file: " + this.file);
        }
        return this.file().mkdirs();
    }

    public boolean exists() {
        if (this.type == FileType.Classpath) {
            return FileDescriptor.class.getResource("/" + this.file.getPath().replace('\\', '/')) != null;
        }
        return this.file().exists();
    }

    public boolean delete() {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot delete a classpath file: " + this.file);
        }
        return this.file().delete();
    }

    public boolean deleteDirectory() {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot delete a classpath file: " + this.file);
        }
        return FileDescriptor.deleteDirectory(this.file());
    }

    public void copyTo(FileDescriptor dest) {
        if (!this.isDirectory()) {
            if (dest.isDirectory()) {
                dest = dest.child(this.name());
            }
            FileDescriptor.copyFile(this, dest);
            return;
        }
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new RuntimeException("Destination exists but is not a directory: " + dest);
            }
        } else {
            dest.mkdirs();
            if (!dest.isDirectory()) {
                throw new RuntimeException("Destination directory cannot be created: " + dest);
            }
        }
        dest = dest.child(this.name());
        FileDescriptor.copyDirectory(this, dest);
    }

    public void moveTo(FileDescriptor dest) {
        if (this.type == FileType.Classpath) {
            throw new RuntimeException("Cannot move a classpath file: " + this.file);
        }
        this.copyTo(dest);
        this.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        if (this.type == FileType.Classpath || !this.file.exists()) {
            InputStream input = this.read();
            try {
                long l = input.available();
                return l;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            return 0L;
        }
        return this.file().length();
    }

    public long lastModified() {
        return this.file().lastModified();
    }

    public String toString() {
        return this.file.getPath();
    }

    public static FileDescriptor tempFile(String prefix) {
        try {
            return new FileDescriptor(File.createTempFile(prefix, null));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create temp file.", ex);
        }
    }

    public static FileDescriptor tempDirectory(String prefix) {
        try {
            File file = File.createTempFile(prefix, null);
            if (!file.delete()) {
                throw new IOException("Unable to delete temp file: " + file);
            }
            if (!file.mkdir()) {
                throw new IOException("Unable to create temp directory: " + file);
            }
            return new FileDescriptor(file);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create temp file.", ex);
        }
    }

    private static boolean deleteDirectory(File file) {
        File[] files;
        if (file.exists() && (files = file.listFiles()) != null) {
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                if (files[i].isDirectory()) {
                    FileDescriptor.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return file.delete();
    }

    private static void copyFile(FileDescriptor source, FileDescriptor dest) {
        try {
            dest.write(source.read(), false);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error copying source file: " + source.file + " (" + (Object)((Object)source.type) + ")\nTo destination: " + dest.file + " (" + (Object)((Object)dest.type) + ")", ex);
        }
    }

    private static void copyDirectory(FileDescriptor sourceDir, FileDescriptor destDir) {
        destDir.mkdirs();
        for (FileDescriptor srcFile : sourceDir.list()) {
            FileDescriptor destFile = destDir.child(srcFile.name());
            if (srcFile.isDirectory()) {
                FileDescriptor.copyDirectory(srcFile, destFile);
                continue;
            }
            FileDescriptor.copyFile(srcFile, destFile);
        }
    }

    public static enum FileType {
        Classpath,
        Absolute;

    }
}

