/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.asm.ControllablePlugin;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerEvents;
import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.ControllerProperties;
import com.mrcrayfish.controllable.client.ControllerToast;
import com.mrcrayfish.controllable.client.GuiEvents;
import com.mrcrayfish.controllable.client.IControllerListener;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.RenderEvents;
import com.mrcrayfish.controllable.client.gui.ButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.settings.ControllerOptions;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Controllable
extends DummyModContainer
implements IControllerListener {
    public static final Logger LOGGER = LogManager.getLogger((String)"Controllable");
    private static ControllerOptions options;
    private static ControllerManager manager;
    private static Controller controller;
    private static ControllerInput input;
    private static File configFolder;

    public Controllable() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "controllable";
        meta.name = "Controllable";
        meta.version = "0.11.1";
        meta.logoFile = "controllable.png";
        meta.authorList = Collections.singletonList("MrCrayfish");
        meta.updateJSON = "https://raw.githubusercontent.com/MrCrayfish/Controllable/master/update.json";
        meta.url = "https://mrcrayfish.com/mod?id=controllable";
        meta.description = "Adds in the ability to use a controller to play Minecraft";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public File getSource() {
        return ControllablePlugin.location;
    }

    public boolean shouldLoadInEnvironment() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Nullable
    public static Controller getController() {
        return controller;
    }

    public static ControllerInput getInput() {
        return input;
    }

    public static ControllerManager getManager() {
        return manager;
    }

    public static ControllerOptions getOptions() {
        return options;
    }

    public static File getConfigFolder() {
        return configFolder;
    }

    @Subscribe
    public void onPreInit(FMLPreInitializationEvent event) {
        int jid;
        Minecraft mc = Minecraft.func_71410_x();
        configFolder = new File(mc.field_71412_D, "config");
        manager = new ControllerManager();
        manager.addControllerListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> manager.close()));
        ControllerProperties.load(event.getModConfigurationDirectory());
        options = new ControllerOptions(mc, mc.field_71412_D);
        if (options.isAutoSelect() && (jid = manager.getFirstControllerJid()) != -1) {
            Controllable.setController(new Controller(jid));
        }
        Mappings.load(configFolder);
        MinecraftForge.EVENT_BUS.register((Object)this);
        input = new ControllerInput();
        MinecraftForge.EVENT_BUS.register((Object)input);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new GuiEvents(manager));
        MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
        this.startControllerThread();
    }

    @Subscribe
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        BindingRegistry.getInstance().load();
    }

    @Override
    public void connected(int jid) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (controller == null) {
                if (Controllable.getOptions().isAutoSelect()) {
                    Controllable.setController(new Controller(jid));
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null && controller != null) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ControllerToast(true, controller.getName()));
                }
            }
        });
    }

    @Override
    public void disconnected(int jid) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (controller != null && controller.getJid() == jid) {
                Controller oldController = controller;
                Controllable.setController(null);
                if (Controllable.getOptions().isAutoSelect() && manager.getControllerCount() > 0) {
                    Optional<Integer> optional = manager.getControllers().keySet().stream().min(Comparator.comparing(i -> i));
                    optional.ifPresent(minJid -> Controllable.setController(new Controller((int)minJid)));
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ControllerToast(false, oldController.getName()));
                }
            }
        });
    }

    public static void setController(@Nullable Controller controller) {
        if (controller != null) {
            Controllable.controller = controller;
            Mappings.updateControllerMappings(controller);
        } else {
            Controllable.controller = null;
        }
    }

    private void startControllerThread() {
        Runnable r = () -> {
            long pollInterval = ControllerProperties.getPollRate();
            while (true) {
                manager.update();
                if (controller != null) {
                    this.gatherAndQueueControllerInput();
                }
                try {
                    Thread.sleep(pollInterval);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        };
        Thread controllerPollThread = new Thread(r, "Controller Input");
        controllerPollThread.setDaemon(true);
        controllerPollThread.start();
    }

    private void gatherAndQueueControllerInput() {
        Controller currentController = controller;
        if (currentController == null) {
            return;
        }
        ButtonStates states = new ButtonStates();
        states.setState(0, this.getButtonState(0));
        states.setState(1, this.getButtonState(1));
        states.setState(2, this.getButtonState(2));
        states.setState(3, this.getButtonState(3));
        states.setState(4, this.getButtonState(4));
        states.setState(5, this.getButtonState(5));
        states.setState(6, this.getButtonState(6));
        states.setState(7, this.getButtonState(7));
        states.setState(8, this.getButtonState(8));
        states.setState(9, this.getButtonState(9));
        states.setState(10, this.getButtonState(10));
        states.setState(11, currentController.getLTriggerValue() > 0.5f);
        states.setState(12, currentController.getRTriggerValue() > 0.5f);
        states.setState(13, this.getButtonState(11));
        states.setState(14, this.getButtonState(12));
        states.setState(15, this.getButtonState(13));
        states.setState(16, this.getButtonState(14));
        Minecraft.func_71410_x().func_152344_a(() -> this.processButtons(states));
    }

    private void processButtons(ButtonStates states) {
        ButtonBinding.tick();
        for (int i = 0; i < Buttons.BUTTONS.length; ++i) {
            this.processButton(Buttons.BUTTONS[i], states);
        }
    }

    private void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof ControllerLayoutScreen) {
            ((ControllerLayoutScreen)screen).processButton(index, newStates);
            return;
        }
        if (controller == null) {
            return;
        }
        if (controller.getMapping() != null) {
            index = controller.getMapping().remap(index);
        }
        if (index == -1) {
            return;
        }
        ButtonStates states = controller.getButtonsStates();
        if (state) {
            if (!states.getState(index)) {
                states.setState(index, true);
                if (screen instanceof ButtonBindingScreen && ((ButtonBindingScreen)screen).processButton(index)) {
                    return;
                }
                input.handleButtonInput(controller, index, true);
            }
        } else if (states.getState(index)) {
            states.setState(index, false);
            input.handleButtonInput(controller, index, false);
        }
    }

    public static boolean isButtonPressed(int button) {
        return controller != null && controller.getButtonsStates().getState(button);
    }

    private boolean getButtonState(int buttonCode) {
        return controller != null && controller.getSDL2Controller().getButton(buttonCode);
    }
}

