/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Mappings;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import uk.co.electronstudio.sdl2gdx.SDL2Controller;

public class Controller {
    private int jid;
    private String cachedName;
    private Mappings.Entry mapping;
    private SDL2Controller controller;
    private ButtonStates states;

    public Controller(int jid) {
        this.jid = jid;
        this.controller = Controllable.getManager().getSDL2ControllerById(jid);
        if (this.controller == null) {
            throw new IllegalArgumentException("Illegal controller jid: " + jid);
        }
        this.states = new ButtonStates();
        this.getName();
    }

    public int getJid() {
        return this.jid;
    }

    public SDL2Controller getSDL2Controller() {
        return this.controller;
    }

    public ButtonStates getButtonsStates() {
        return this.states;
    }

    public String getName() {
        if (this.controller.isConnected()) {
            if (this.cachedName == null) {
                this.cachedName = this.controller.getName().replace("SDL GameController ", "").replace("SDL Joystick ", "");
            }
            return this.cachedName;
        }
        return I18n.func_135052_a((String)"controllable.toast.controller", (Object[])new Object[0]);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public float getLTriggerValue() {
        return (this.controller.getAxis(4) + 1.0f) / 2.0f;
    }

    public float getRTriggerValue() {
        return (this.controller.getAxis(5) + 1.0f) / 2.0f;
    }

    public float getLThumbStickXValue() {
        int axis = this.isThumbsticksSwitched() ? 2 : 0;
        return this.controller.getAxis(axis) * (float)(this.isFlipLeftX() ? -1 : 1);
    }

    public float getLThumbStickYValue() {
        int axis = this.isThumbsticksSwitched() ? 3 : 1;
        return this.controller.getAxis(axis) * (float)(this.isFlipLeftY() ? -1 : 1);
    }

    public float getRThumbStickXValue() {
        int axis = this.isThumbsticksSwitched() ? 0 : 2;
        return this.controller.getAxis(axis) * (float)(this.isFlipRightX() ? -1 : 1);
    }

    public float getRThumbStickYValue() {
        int axis = this.isThumbsticksSwitched() ? 1 : 3;
        return this.controller.getAxis(axis) * (float)(this.isFlipRightY() ? -1 : 1);
    }

    public void setMapping(Mappings.Entry mapping) {
        this.mapping = mapping;
    }

    @Nullable
    public Mappings.Entry getMapping() {
        return this.mapping;
    }

    private boolean isThumbsticksSwitched() {
        return this.mapping != null && this.mapping.isThumbsticksSwitched();
    }

    public boolean isFlipLeftX() {
        return this.mapping != null && this.mapping.isFlipLeftX();
    }

    public boolean isFlipLeftY() {
        return this.mapping != null && this.mapping.isFlipLeftY();
    }

    public boolean isFlipRightX() {
        return this.mapping != null && this.mapping.isFlipRightX();
    }

    public boolean isFlipRightY() {
        return this.mapping != null && this.mapping.isFlipRightY();
    }
}

