/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SlotNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.GatherNavigationPointsEvent;
import com.mrcrayfish.controllable.mixin.client.CreativeScreenMixin;
import com.mrcrayfish.controllable.mixin.client.RecipeBookGuiMixin;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.advancements.GuiScreenAdvancements;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.recipebook.GuiButtonRecipe;
import net.minecraft.client.gui.recipebook.GuiButtonRecipeTab;
import net.minecraft.client.gui.recipebook.GuiRecipeBook;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookPage;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ControllerInput {
    private static final ResourceLocation CURSOR_TEXTURE = new ResourceLocation("controllable", "textures/gui/cursor.png");
    private int lastUse = 0;
    private boolean keyboardSneaking = false;
    private boolean sneaking = false;
    private boolean isFlying = false;
    private boolean nearSlot = false;
    private boolean moving = false;
    private boolean preventReset;
    private double virtualMouseX;
    private double virtualMouseY;
    private int prevTargetMouseX;
    private int prevTargetMouseY;
    private int targetMouseX;
    private int targetMouseY;
    private double mouseSpeedX;
    private double mouseSpeedY;
    private int lastRealMouseX;
    private int lastRealMouseY;
    private boolean moved;
    private float targetPitch;
    private float targetYaw;
    private int dropCounter = -1;

    public double getVirtualMouseX() {
        return this.virtualMouseX;
    }

    public double getVirtualMouseY() {
        return this.virtualMouseY;
    }

    private void setControllerInUse() {
        this.lastUse = 100;
    }

    public boolean isControllerInUse() {
        return this.lastUse > 0;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    public void resetLastUse() {
        if (!this.preventReset) {
            this.lastUse = 0;
        }
        this.preventReset = false;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Controller controller;
            if (Mouse.getX() != this.lastRealMouseX || Mouse.getY() != this.lastRealMouseY) {
                this.resetLastUse();
            }
            this.lastRealMouseX = Mouse.getX();
            this.lastRealMouseY = Mouse.getY();
            this.prevTargetMouseX = this.targetMouseX;
            this.prevTargetMouseY = this.targetMouseY;
            if (this.lastUse > 0) {
                --this.lastUse;
            }
            if ((controller = Controllable.getController()) == null) {
                return;
            }
            if ((Math.abs(controller.getLTriggerValue()) > 0.5f || Math.abs(controller.getRTriggerValue()) > 0.5f) && !(Minecraft.func_71410_x().field_71462_r instanceof ControllerLayoutScreen)) {
                this.setControllerInUse();
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (Mouse.isGrabbed()) {
                return;
            }
            if (mc.field_71462_r == null || mc.field_71462_r instanceof ControllerLayoutScreen) {
                return;
            }
            float deadZone = (float)Math.min(1.0, Controllable.getOptions().getDeadZone() + 0.25);
            boolean lastMoving = this.moving;
            boolean bl = this.moving = Math.abs(controller.getLThumbStickXValue()) >= deadZone || Math.abs(controller.getLThumbStickYValue()) >= deadZone;
            if (this.moving) {
                float xAxis;
                if (!lastMoving) {
                    double mouseX = Mouse.getX();
                    double mouseY = Mouse.getY();
                    if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse()) {
                        mouseX = this.virtualMouseX;
                        mouseY = this.virtualMouseY;
                    }
                    this.prevTargetMouseX = this.targetMouseX = (int)mouseX;
                    this.prevTargetMouseY = this.targetMouseY = (int)mouseY;
                }
                this.mouseSpeedX = Math.abs(xAxis = controller.getLThumbStickXValue()) >= deadZone ? (double)(Math.signum(xAxis) * (Math.abs(xAxis) - deadZone) / (1.0f - deadZone)) : 0.0;
                float yAxis = controller.getLThumbStickYValue();
                this.mouseSpeedY = Math.abs(yAxis) >= deadZone ? (double)(Math.signum(yAxis) * (Math.abs(yAxis) - deadZone) / (1.0f - deadZone)) : 0.0;
                this.setControllerInUse();
            }
            if (this.lastUse <= 0) {
                this.mouseSpeedX = 0.0;
                this.mouseSpeedY = 0.0;
                return;
            }
            if (Math.abs(this.mouseSpeedX) > 0.0 || Math.abs(this.mouseSpeedY) > 0.0) {
                GuiButton hoveredListener;
                GuiRecipeBook recipeBook;
                GuiContainer screen;
                ScaledResolution resolution = new ScaledResolution(mc);
                double mouseSpeed = Controllable.getOptions().getMouseSpeed() * (double)resolution.func_78325_e();
                if (mc.field_71462_r instanceof GuiContainer && (screen = (GuiContainer)mc.field_71462_r).getSlotUnderMouse() != null) {
                    mouseSpeed *= 0.5;
                }
                ArrayList<Object> widgets = new ArrayList<Object>(mc.field_71462_r.field_146292_n);
                if (mc.field_71462_r instanceof IRecipeShownListener && (recipeBook = ((IRecipeShownListener)mc.field_71462_r).func_194310_f()).func_191878_b()) {
                    widgets.add(((RecipeBookGuiMixin)recipeBook).getToggleRecipesBtn());
                    widgets.addAll(((RecipeBookGuiMixin)recipeBook).getRecipeTabs());
                    RecipeBookPage recipeBookPage = ((RecipeBookGuiMixin)recipeBook).getRecipeBookPage();
                    widgets.addAll(((RecipeBookPageAccessor)recipeBookPage).getButtons());
                    widgets.add(((RecipeBookPageAccessor)recipeBookPage).getForwardButton());
                    widgets.add(((RecipeBookPageAccessor)recipeBookPage).getBackButton());
                }
                if ((hoveredListener = (GuiButton)widgets.stream().filter(o -> o != null && o.func_146115_a()).findFirst().orElse(null)) != null) {
                    mouseSpeed *= 0.6;
                }
                this.targetMouseX = (int)((double)this.targetMouseX + mouseSpeed * this.mouseSpeedX);
                this.targetMouseX = MathHelper.func_76125_a((int)this.targetMouseX, (int)0, (int)mc.field_71443_c);
                this.targetMouseY = (int)((double)this.targetMouseY + mouseSpeed * this.mouseSpeedY);
                this.targetMouseY = MathHelper.func_76125_a((int)this.targetMouseY, (int)0, (int)mc.field_71440_d);
                this.setControllerInUse();
                this.moved = true;
            }
            this.moveMouseToClosestSlot(this.moving, mc.field_71462_r);
            if (mc.field_71462_r instanceof GuiContainerCreative) {
                this.handleCreativeScrolling((GuiContainerCreative)mc.field_71462_r, controller);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onScreenInit(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            this.nearSlot = false;
            this.moved = false;
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
            this.targetMouseX = this.prevTargetMouseX = (int)((float)mc.field_71443_c / 2.0f);
            this.virtualMouseX = this.prevTargetMouseX;
            this.targetMouseY = this.prevTargetMouseY = (int)((float)mc.field_71440_d / 2.0f);
            this.virtualMouseY = this.prevTargetMouseY;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r == null || this.targetMouseX == this.prevTargetMouseX && this.targetMouseY == this.prevTargetMouseY || mc.field_71462_r instanceof ControllerLayoutScreen)) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            double mouseX = (double)((float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * partialTicks) + 0.5;
            double mouseY = (double)((float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * partialTicks) + 0.5;
            this.setMousePosition(mouseX, mouseY);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && this.lastUse > 0) {
            GlStateManager.func_179094_E();
            CursorType type = Controllable.getOptions().getCursorType();
            Minecraft minecraft = event.getGui().field_146297_k;
            if (minecraft.field_71439_g == null || minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() || type == CursorType.CONSOLE) {
                double mouseX = (float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * Minecraft.func_71410_x().func_184121_ak();
                double mouseY = (float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * Minecraft.func_71410_x().func_184121_ak();
                ScaledResolution resolution = new ScaledResolution(minecraft);
                GlStateManager.func_179137_b((double)(mouseX / (double)resolution.func_78325_e()), (double)(mouseY / (double)resolution.func_78325_e()), (double)500.0);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179098_w();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                event.getGui().field_146297_k.func_110434_K().func_110577_a(CURSOR_TEXTURE);
                if (type == CursorType.CONSOLE) {
                    GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                }
                GuiScreen.func_146110_a((int)-8, (int)-8, (float)(this.nearSlot ? 16.0f : 0.0f), (float)(type.ordinal() * 16), (int)16, (int)16, (float)32.0f, (float)(CursorType.values().length * 16));
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        EntityPlayerSP player;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        double mouseX = this.virtualMouseX * (double)resolution.func_78326_a() / (double)mc.field_71443_c;
        double mouseY = this.virtualMouseY * (double)resolution.func_78328_b() / (double)mc.field_71440_d;
        if (mc.field_71462_r == null || this.lastUse > 0) {
            // empty if block
        }
        if ((player = mc.field_71439_g) == null) {
            return;
        }
        if (mc.field_71462_r == null && (this.targetYaw != 0.0f || this.targetPitch != 0.0f)) {
            float elapsedTicks = Minecraft.func_71410_x().func_193989_ak();
            player.func_70082_c(this.targetYaw / 0.15f * elapsedTicks, this.targetPitch / 0.15f * (float)(Controllable.getOptions().isInvertLook() ? -1 : 1) * elapsedTicks);
            if (player.func_184187_bx() != null) {
                player.func_184187_bx().func_184190_l((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (mc.field_71462_r == null) {
            ControllerEvent.Turn turnEvent;
            double rotationSpeed;
            float deadZone = (float)Controllable.getOptions().getDeadZone();
            if (Math.abs(controller.getRThumbStickXValue()) >= deadZone) {
                this.setControllerInUse();
                rotationSpeed = Controllable.getOptions().getRotationSpeed();
                turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed, (float)rotationSpeed * 0.75f);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimX = (float)(controller.getRThumbStickXValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetYaw = turnEvent.getYawSpeed() * (controller.getRThumbStickXValue() - deadZoneTrimX) / (1.0f - deadZone) * 0.33f;
                }
            }
            if (Math.abs(controller.getRThumbStickYValue()) >= deadZone) {
                this.setControllerInUse();
                rotationSpeed = Controllable.getOptions().getRotationSpeed();
                turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed, (float)rotationSpeed * 0.75f);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimY = (float)(controller.getRThumbStickYValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetPitch = turnEvent.getPitchSpeed() * (-controller.getRThumbStickYValue() - deadZoneTrimY) / (1.0f - deadZone) * 0.33f;
                }
            }
        }
        if (mc.field_71462_r == null && ButtonBindings.DROP_ITEM.isButtonDown()) {
            this.setControllerInUse();
            ++this.dropCounter;
        }
        if (this.dropCounter > 20) {
            if (!mc.field_71439_g.func_175149_v()) {
                mc.field_71439_g.func_71040_bB(true);
            }
            this.dropCounter = 0;
        } else if (this.dropCounter > 0 && !ButtonBindings.DROP_ITEM.isButtonDown()) {
            if (!mc.field_71439_g.func_175149_v()) {
                mc.field_71439_g.func_71040_bB(false);
            }
            this.dropCounter = 0;
        }
    }

    @SubscribeEvent
    public void onInputUpdate(InputUpdateEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (this.keyboardSneaking && !mc.field_71474_y.field_74311_E.func_151470_d()) {
            this.sneaking = false;
            this.keyboardSneaking = false;
        }
        if (mc.field_71474_y.field_74311_E.func_151470_d()) {
            this.sneaking = true;
            this.keyboardSneaking = true;
        }
        if (mc.field_71439_g.field_71075_bZ.field_75100_b || mc.field_71439_g.func_184218_aH()) {
            this.sneaking = mc.field_71474_y.field_74311_E.func_151470_d();
            this.sneaking |= ButtonBindings.SNEAK.isButtonDown();
            if (ButtonBindings.SNEAK.isButtonDown()) {
                this.setControllerInUse();
            }
            this.isFlying = true;
        } else if (this.isFlying) {
            this.sneaking = false;
            this.isFlying = false;
        }
        event.getMovementInput().field_78899_d = this.sneaking;
        if (mc.field_71462_r == null) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new ControllerEvent.Move(controller))) {
                int dir;
                float deadZone = (float)Controllable.getOptions().getDeadZone();
                if (Math.abs(controller.getLThumbStickYValue()) >= deadZone) {
                    this.setControllerInUse();
                    dir = controller.getLThumbStickYValue() > 0.0f ? -1 : 1;
                    event.getMovementInput().field_187255_c = dir > 0;
                    event.getMovementInput().field_187256_d = dir < 0;
                    event.getMovementInput().field_192832_b = (float)dir * MathHelper.func_76131_a((float)((Math.abs(controller.getLThumbStickYValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                    if (event.getMovementInput().field_78899_d) {
                        event.getMovementInput().field_192832_b = (float)((double)event.getMovementInput().field_192832_b * 0.3);
                    }
                }
                if (player.func_184187_bx() instanceof EntityBoat) {
                    deadZone = 0.5f;
                }
                if (Math.abs(controller.getLThumbStickXValue()) >= deadZone) {
                    this.setControllerInUse();
                    dir = controller.getLThumbStickXValue() > 0.0f ? -1 : 1;
                    event.getMovementInput().field_187258_f = dir < 0;
                    event.getMovementInput().field_187257_e = dir > 0;
                    event.getMovementInput().field_78902_a = (float)dir * MathHelper.func_76131_a((float)((Math.abs(controller.getLThumbStickXValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                    if (event.getMovementInput().field_78899_d) {
                        event.getMovementInput().field_78902_a = (float)((double)event.getMovementInput().field_78902_a * 0.3);
                    }
                }
            }
            if (ButtonBindings.JUMP.isButtonDown()) {
                event.getMovementInput().field_78901_c = true;
            }
        }
        if (ButtonBindings.USE_ITEM.isButtonDown() && mc.field_71467_ac == 0 && !mc.field_71439_g.func_184587_cr()) {
            mc.func_147121_ag();
        }
    }

    public void handleButtonInput(Controller controller, int button, boolean state) {
        this.setControllerInUse();
        ControllerEvent.ButtonInput eventInput = new ControllerEvent.ButtonInput(controller, button, state);
        if (MinecraftForge.EVENT_BUS.post((Event)eventInput)) {
            return;
        }
        button = eventInput.getModifiedButton();
        ButtonBinding.setButtonState(button, state);
        ControllerEvent.Button event = new ControllerEvent.Button(controller);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (state) {
            if (ButtonBindings.FULLSCREEN.isButtonPressed()) {
                mc.func_71352_k();
            } else if (ButtonBindings.SCREENSHOT.isButtonPressed()) {
                if (mc.field_71441_e != null) {
                    ScreenShotHelper.func_148260_a((File)mc.field_71412_D, (int)mc.field_71443_c, (int)mc.field_71440_d, (Framebuffer)mc.func_147110_a());
                }
            } else if (mc.field_71462_r == null) {
                if (ButtonBindings.INVENTORY.isButtonPressed()) {
                    if (mc.field_71442_b.func_110738_j()) {
                        mc.field_71439_g.func_175163_u();
                    } else {
                        mc.func_193032_ao().func_193296_a();
                        mc.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)mc.field_71439_g));
                    }
                } else if (ButtonBindings.SPRINT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.func_70031_b(true);
                    }
                } else if (ButtonBindings.SNEAK.isButtonPressed()) {
                    if (mc.field_71439_g != null && !mc.field_71439_g.field_71075_bZ.field_75100_b && !mc.field_71439_g.func_184218_aH()) {
                        this.sneaking = !this.sneaking;
                    }
                } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.field_71071_by.func_70453_c(-1);
                    }
                } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.field_71071_by.func_70453_c(1);
                    }
                } else if (ButtonBindings.SWAP_HANDS.isButtonPressed()) {
                    if (mc.field_71439_g != null && !mc.field_71439_g.func_175149_v() && mc.func_147114_u() != null) {
                        mc.func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.SWAP_HELD_ITEMS, BlockPos.field_177992_a, EnumFacing.DOWN));
                    }
                } else if (ButtonBindings.TOGGLE_PERSPECTIVE.isButtonPressed() && Mouse.isGrabbed()) {
                    this.cycleThirdPersonView();
                } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.func_71385_j();
                    }
                } else if (ButtonBindings.ADVANCEMENTS.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.func_147108_a((GuiScreen)new GuiScreenAdvancements(mc.field_71439_g.field_71174_a.func_191982_f()));
                    }
                } else if (ButtonBindings.CINEMATIC_CAMERA.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71474_y.field_74326_T = !mc.field_71474_y.field_74326_T;
                    }
                } else if (ButtonBindings.DEBUG_INFO.isButtonPressed()) {
                    mc.field_71474_y.field_74330_P = !mc.field_71474_y.field_74330_P;
                } else if (mc.field_71439_g != null && !mc.field_71439_g.func_184587_cr()) {
                    if (ButtonBindings.ATTACK.isButtonPressed()) {
                        mc.func_147116_af();
                    } else if (ButtonBindings.USE_ITEM.isButtonPressed()) {
                        mc.func_147121_ag();
                    } else if (ButtonBindings.PICK_BLOCK.isButtonPressed()) {
                        mc.func_147112_ai();
                    }
                }
            } else if (ButtonBindings.INVENTORY.isButtonPressed()) {
                if (mc.field_71439_g != null) {
                    mc.field_71439_g.func_71053_j();
                }
            } else if (ButtonBindings.PREVIOUS_CREATIVE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof GuiContainerCreative) {
                    this.scrollCreativeTabs((GuiContainerCreative)mc.field_71462_r, 1);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipePage(recipeShownListener.func_194310_f(), 1);
                }
            } else if (ButtonBindings.NEXT_CREATIVE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof GuiContainerCreative) {
                    this.scrollCreativeTabs((GuiContainerCreative)mc.field_71462_r, -1);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipePage(recipeShownListener.func_194310_f(), -1);
                }
            } else if (ButtonBindings.NEXT_RECIPE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipeTab(recipeShownListener.func_194310_f(), -1);
                }
            } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonPressed()) {
                if (mc.field_71462_r instanceof IRecipeShownListener) {
                    IRecipeShownListener recipeShownListener = (IRecipeShownListener)mc.field_71462_r;
                    this.scrollRecipeTab(recipeShownListener.func_194310_f(), 1);
                }
            } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                if (mc.field_71462_r instanceof GuiIngameMenu) {
                    mc.func_147108_a(null);
                }
            } else if (ButtonBindings.NAVIGATE_UP.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.UP);
            } else if (ButtonBindings.NAVIGATE_DOWN.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.DOWN);
            } else if (ButtonBindings.NAVIGATE_LEFT.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.LEFT);
            } else if (ButtonBindings.NAVIGATE_RIGHT.isButtonPressed()) {
                this.navigateMouse(mc.field_71462_r, Navigate.RIGHT);
            } else if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseClick(mc.field_71462_r, 0);
                if (Controllable.getOptions().isQuickCraft()) {
                    this.craftRecipeBookItem();
                }
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseClick(mc.field_71462_r, 1);
            } else if (button == ButtonBindings.QUICK_MOVE.getButton() && mc.field_71439_g != null) {
                if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.invokeMouseClick(mc.field_71462_r, 0);
                } else {
                    this.invokeMouseReleased(mc.field_71462_r, 1);
                }
            }
        } else if (mc.field_71462_r != null) {
            if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseReleased(mc.field_71462_r, 0);
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseReleased(mc.field_71462_r, 1);
            }
        }
    }

    private void cycleThirdPersonView() {
        Minecraft mc = Minecraft.func_71410_x();
        int thirdPersonView = mc.field_71474_y.field_74320_O;
        mc.field_71474_y.field_74320_O = (thirdPersonView + 1) % 3;
        if (mc.field_71474_y.field_74320_O == 0) {
            mc.field_71460_t.func_175066_a(mc.func_175606_aa());
        } else if (mc.field_71474_y.field_74320_O == 1) {
            mc.field_71460_t.func_175066_a(null);
        }
    }

    private void scrollCreativeTabs(GuiContainerCreative creative, int dir) {
        this.setControllerInUse();
        try {
            Method method = ObfuscationReflectionHelper.findMethod(GuiContainerCreative.class, (String)"func_147050_b", Void.TYPE, (Class[])new Class[]{CreativeTabs.class});
            method.setAccessible(true);
            if (dir > 0) {
                if (creative.func_147056_g() < CreativeTabs.field_78032_a.length - 1) {
                    method.invoke((Object)creative, CreativeTabs.field_78032_a[creative.func_147056_g() + 1]);
                }
            } else if (dir < 0 && creative.func_147056_g() > 0) {
                method.invoke((Object)creative, CreativeTabs.field_78032_a[creative.func_147056_g() - 1]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void scrollRecipeTab(GuiRecipeBook recipeBook, int dir) {
        RecipeBookGuiMixin recipeBookMixin = (RecipeBookGuiMixin)recipeBook;
        GuiButtonRecipeTab currentTab = recipeBookMixin.getCurrentTab();
        List<GuiButtonRecipeTab> tabs = recipeBookMixin.getRecipeTabs();
        int nextTabIndex = tabs.indexOf(currentTab) + dir;
        if (nextTabIndex >= 0 && nextTabIndex < tabs.size()) {
            GuiButtonRecipeTab newTab = tabs.get(nextTabIndex);
            currentTab.func_191753_b(false);
            recipeBookMixin.setCurrentTab(newTab);
            newTab.func_191753_b(true);
            recipeBookMixin.invokeUpdateCollections(true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    private void scrollRecipePage(GuiRecipeBook recipeBook, int dir) {
        RecipeBookPageAccessor page = (RecipeBookPageAccessor)((RecipeBookGuiMixin)recipeBook).getRecipeBookPage();
        if (dir > 0 && page.getForwardButton().field_146125_m || dir < 0 && page.getBackButton().field_146125_m) {
            int currentPage = page.getCurrentPage();
            page.setCurrentPage(currentPage + dir);
            page.invokeUpdateButtonsForPage();
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    private void navigateMouse(GuiScreen screen, Navigate navigate) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        int mouseX = (int)((double)this.targetMouseX * (double)resolution.func_78326_a() / (double)mc.field_71443_c);
        int mouseY = (int)((double)this.targetMouseY * (double)resolution.func_78328_b() / (double)mc.field_71440_d);
        List<NavigationPoint> points = this.gatherNavigationPoints(screen);
        GatherNavigationPointsEvent event = new GatherNavigationPointsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        points.addAll(event.getPoints());
        List targetPoints = points.stream().filter(point -> navigate.getPredicate().test((NavigationPoint)point, mouseX, mouseY)).collect(Collectors.toList());
        if (targetPoints.isEmpty()) {
            return;
        }
        Vec3d mousePos = new Vec3d((double)mouseX, (double)mouseY, 0.0);
        Optional<NavigationPoint> minimumPointOptional = targetPoints.stream().min(navigate.getMinComparator(mouseX, mouseY));
        double minimumDelta = navigate.getKeyExtractor().apply(minimumPointOptional.get(), mousePos) + 10.0;
        Optional<NavigationPoint> targetPointOptional = targetPoints.stream().filter(point -> navigate.getKeyExtractor().apply((NavigationPoint)point, mousePos) <= minimumDelta).min(Comparator.comparing(p -> p.distanceTo(mouseX, mouseY)));
        if (targetPointOptional.isPresent()) {
            NavigationPoint targetPoint = targetPointOptional.get();
            int screenX = (int)(targetPoint.getX() / ((double)resolution.func_78326_a() / (double)mc.field_71443_c));
            int screenY = (int)(targetPoint.getY() / ((double)resolution.func_78328_b() / (double)mc.field_71440_d));
            double lastTargetMouseX = this.targetMouseX;
            double lastTargetMouseY = this.targetMouseY;
            this.targetMouseX = this.prevTargetMouseX = screenX;
            this.targetMouseY = this.prevTargetMouseY = screenY;
            this.setMousePosition(screenX, screenY);
            mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187638_cR, (float)2.0f));
        }
    }

    private List<NavigationPoint> gatherNavigationPoints(GuiScreen screen) {
        GuiRecipeBook recipeBook;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        if (screen instanceof GuiContainer) {
            GuiContainer containerScreen = (GuiContainer)screen;
            int guiLeft = containerScreen.getGuiLeft();
            int n = containerScreen.getGuiTop();
            for (Slot slot : containerScreen.field_147002_h.field_75151_b) {
                if (containerScreen.getSlotUnderMouse() == slot) continue;
                int posX = guiLeft + slot.field_75223_e + 8;
                int posY = n + slot.field_75221_f + 8;
                points.add(new SlotNavigationPoint((double)posX, (double)posY, slot));
            }
        }
        ArrayList<Object> widgets = new ArrayList<Object>(screen.field_146292_n);
        if (screen instanceof IRecipeShownListener && (recipeBook = ((IRecipeShownListener)screen).func_194310_f()).func_191878_b()) {
            widgets.add(((RecipeBookGuiMixin)recipeBook).getToggleRecipesBtn());
            widgets.addAll(((RecipeBookGuiMixin)recipeBook).getRecipeTabs());
            RecipeBookPage recipeBookPage = ((RecipeBookGuiMixin)recipeBook).getRecipeBookPage();
            widgets.addAll(((RecipeBookPageAccessor)recipeBookPage).getButtons());
            widgets.add(((RecipeBookPageAccessor)recipeBookPage).getForwardButton());
            widgets.add(((RecipeBookPageAccessor)recipeBookPage).getBackButton());
        }
        for (GuiButton guiButton : widgets) {
            if (guiButton == null || guiButton.func_146115_a() || !guiButton.field_146125_m) continue;
            int posX = guiButton.field_146128_h + guiButton.field_146120_f / 2;
            int posY = guiButton.field_146129_i + guiButton.field_146121_g / 2;
            points.add(new WidgetNavigationPoint((double)posX, (double)posY, guiButton));
        }
        if (screen instanceof GuiContainerCreative) {
            int tabPage = CreativeScreenMixin.getTabPage();
            int n = tabPage * 10;
            int end = Math.min(CreativeTabs.field_78032_a.length, (tabPage + 1) * 10 + 2);
            for (int i = n; i < end; ++i) {
                CreativeTabs group = CreativeTabs.field_78032_a[i];
                if (group == null) continue;
                points.add(this.getCreativeTabPoint((GuiContainerCreative)screen, group));
            }
        }
        return points;
    }

    private BasicNavigationPoint getCreativeTabPoint(GuiContainerCreative screen, CreativeTabs group) {
        boolean topRow = group.func_78023_l();
        int column = group.func_78020_k();
        int width = 28;
        int height = 32;
        int x = screen.getGuiLeft() + width * column;
        int y = screen.getGuiTop();
        x = group.func_192394_m() ? screen.getGuiLeft() + screen.getXSize() - width * (6 - column) : (column > 0 ? x + column : x);
        y = topRow ? y - width : y + (screen.getYSize() - 4);
        return new BasicNavigationPoint((double)x + (double)width / 2.0, (double)y + (double)height / 2.0);
    }

    private void craftRecipeBookItem() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (!(mc.field_71462_r instanceof GuiContainer) || !(mc.field_71462_r instanceof IRecipeShownListener)) {
            return;
        }
        IRecipeShownListener listener = (IRecipeShownListener)mc.field_71462_r;
        if (!listener.func_194310_f().func_191878_b()) {
            return;
        }
        GuiContainer screen = (GuiContainer)mc.field_71462_r;
        RecipeBookPage recipeBookPage = ((RecipeBookGuiMixin)listener.func_194310_f()).getRecipeBookPage();
        GuiButtonRecipe recipe = ((RecipeBookPageAccessor)recipeBookPage).getButtons().stream().filter(GuiButton::func_146115_a).findFirst().orElse(null);
        if (recipe != null) {
            Slot slot = (Slot)screen.field_147002_h.field_75151_b.get(0);
            if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.invokeMouseClick((GuiScreen)screen, 0, screen.getGuiLeft() + slot.field_75223_e + 8, screen.getGuiTop() + slot.field_75221_f + 8);
            } else {
                this.invokeMouseReleased((GuiScreen)screen, 0, screen.getGuiLeft() + slot.field_75223_e + 8, screen.getGuiTop() + slot.field_75221_f + 8);
            }
        }
    }

    private void moveMouseToClosestSlot(boolean moving, GuiScreen screen) {
        this.nearSlot = false;
        if (screen instanceof GuiContainer) {
            if (!this.moved) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution resolution = new ScaledResolution(mc);
            GuiContainer guiContainer = (GuiContainer)screen;
            int guiLeft = guiContainer.getGuiLeft();
            int guiTop = guiContainer.getGuiTop();
            int mouseX = (int)((double)this.targetMouseX * (double)resolution.func_78326_a() / (double)mc.field_71443_c);
            int mouseY = (int)((double)this.targetMouseY * (double)resolution.func_78328_b() / (double)mc.field_71440_d);
            Slot closestSlot = null;
            double closestDistance = -1.0;
            for (Slot slot : guiContainer.field_147002_h.field_75151_b) {
                int posX = guiLeft + slot.field_75223_e + 8;
                int posY = guiTop + slot.field_75221_f + 8;
                double distance = Math.sqrt(Math.pow(posX - mouseX, 2.0) + Math.pow(posY - mouseY, 2.0));
                if (closestDistance != -1.0 && !(distance < closestDistance) || !(distance <= 14.0)) continue;
                closestSlot = slot;
                closestDistance = distance;
            }
            if (closestSlot != null && (closestSlot.func_75216_d() || !mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b())) {
                this.nearSlot = true;
                int slotCenterXScaled = guiLeft + closestSlot.field_75223_e + 8;
                int slotCenterYScaled = guiTop + closestSlot.field_75221_f + 8;
                int slotCenterX = (int)((double)slotCenterXScaled / ((double)resolution.func_78326_a() / (double)mc.field_71443_c));
                int slotCenterY = (int)((double)slotCenterYScaled / ((double)resolution.func_78328_b() / (double)mc.field_71440_d));
                double deltaX = slotCenterX - this.targetMouseX;
                double deltaY = slotCenterY - this.targetMouseY;
                if (!moving) {
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        this.targetMouseX = (int)((double)this.targetMouseX + deltaX * 0.75);
                        this.targetMouseY = (int)((double)this.targetMouseY + deltaY * 0.75);
                    } else {
                        this.mouseSpeedX = 0.0;
                        this.mouseSpeedY = 0.0;
                    }
                }
                this.mouseSpeedX *= 0.75;
                this.mouseSpeedY *= 0.75;
            } else {
                this.mouseSpeedX = 0.0;
                this.mouseSpeedY = 0.0;
            }
        } else {
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
        }
    }

    private void setMousePosition(double mouseX, double mouseY) {
        if (Controllable.getOptions().isVirtualMouse()) {
            this.virtualMouseX = mouseX;
            this.virtualMouseY = mouseY;
        } else {
            Mouse.setCursorPosition((int)((int)mouseX), (int)((int)mouseY));
            this.preventReset = true;
        }
    }

    private void handleCreativeScrolling(GuiContainerCreative creative, Controller controller) {
        try {
            int i = (creative.field_147002_h.field_75151_b.size() + 9 - 1) / 9 - 5;
            int dir = 0;
            if (controller.getRThumbStickYValue() <= -0.8f) {
                dir = 1;
            } else if (controller.getRThumbStickYValue() >= 0.8f) {
                dir = -1;
            }
            Field field = ObfuscationReflectionHelper.findField(GuiContainerCreative.class, (String)"field_147067_x");
            field.setAccessible(true);
            float currentScroll = field.getFloat(creative);
            currentScroll = (float)((double)currentScroll - (double)dir / (double)i);
            currentScroll = MathHelper.func_76131_a((float)currentScroll, (float)0.0f, (float)1.0f);
            field.setFloat(creative, currentScroll);
            ((GuiContainerCreative.ContainerCreative)creative.field_147002_h).func_148329_a(currentScroll);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void handleListScrolling(GuiSlot list, Controller controller) {
        double dir = 0.0;
        if (Math.abs(controller.getRThumbStickYValue()) >= 0.2f) {
            this.setControllerInUse();
            dir = controller.getRThumbStickYValue();
        }
        list.func_148145_f((int)((double)list.func_148148_g() + (dir *= (double)Minecraft.func_71410_x().func_193989_ak()) * 10.0));
    }

    private int getMouseX() {
        Minecraft mc = Minecraft.func_71410_x();
        double mouseX = Mouse.getX();
        if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && this.lastUse > 0) {
            mouseX = this.virtualMouseX;
        }
        ScaledResolution resolution = new ScaledResolution(mc);
        return (int)(mouseX * (double)resolution.func_78326_a() / (double)mc.field_71443_c);
    }

    private int getMouseY() {
        Minecraft mc = Minecraft.func_71410_x();
        double mouseY = Mouse.getY();
        if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && this.lastUse > 0) {
            mouseY = this.virtualMouseY;
        }
        ScaledResolution resolution = new ScaledResolution(mc);
        return (int)(mouseY * (double)resolution.func_78328_b() / (double)mc.field_71440_d);
    }

    private void invokeMouseClick(GuiScreen screen, int button) {
        if (screen != null) {
            int mouseX = this.getMouseX();
            int mouseY = this.getMouseY();
            this.invokeMouseClick(screen, button, mouseX, mouseY);
        }
    }

    private void invokeMouseClick(GuiScreen screen, int button, int mouseX, int mouseY) {
        if (screen != null) {
            screen.field_146287_f = button;
            screen.field_146288_g = Minecraft.func_71386_F();
            try {
                Method mouseClicked = ReflectionHelper.findMethod(GuiScreen.class, (String)"mouseClicked", (String)"func_73864_a", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
                mouseClicked.setAccessible(true);
                mouseClicked.invoke((Object)screen, mouseX, mouseY, button);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void invokeMouseReleased(GuiScreen screen, int button) {
        if (screen != null) {
            int mouseX = this.getMouseX();
            int mouseY = this.getMouseY();
            this.invokeMouseReleased(screen, button, mouseX, mouseY);
        }
    }

    private void invokeMouseReleased(GuiScreen screen, int button, int mouseX, int mouseY) {
        if (screen != null) {
            screen.field_146287_f = -1;
            try {
                Method mouseReleased = ReflectionHelper.findMethod(GuiScreen.class, (String)"mouseReleased", (String)"func_146286_b", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
                mouseReleased.setAccessible(true);
                mouseReleased.invoke((Object)screen, mouseX, mouseY, button);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static interface NavigatePredicate {
        public boolean test(NavigationPoint var1, int var2, int var3);
    }

    private static enum Navigate {
        UP((p, x, y) -> p.getY() < (double)y, (p, v) -> Math.abs(p.getX() - v.field_72450_a)),
        DOWN((p, x, y) -> p.getY() > (double)(y + 1), (p, v) -> Math.abs(p.getX() - v.field_72450_a)),
        LEFT((p, x, y) -> p.getX() < (double)x, (p, v) -> Math.abs(p.getY() - v.field_72448_b)),
        RIGHT((p, x, y) -> p.getX() > (double)(x + 1), (p, v) -> Math.abs(p.getY() - v.field_72448_b));

        private NavigatePredicate predicate;
        private BiFunction<? super NavigationPoint, Vec3d, Double> keyExtractor;

        private Navigate(NavigatePredicate predicate, BiFunction<? super NavigationPoint, Vec3d, Double> keyExtractor) {
            this.predicate = predicate;
            this.keyExtractor = keyExtractor;
        }

        public NavigatePredicate getPredicate() {
            return this.predicate;
        }

        public BiFunction<? super NavigationPoint, Vec3d, Double> getKeyExtractor() {
            return this.keyExtractor;
        }

        public Comparator<NavigationPoint> getMinComparator(int mouseX, int mouseY) {
            return Comparator.comparing(p -> this.keyExtractor.apply((NavigationPoint)p, new Vec3d((double)mouseX, (double)mouseY, 0.0)));
        }

        public static void main(String[] args) {
            int slotX = 10;
            int slotY = 20;
            int mouseX = 50;
            int mouseY = 20;
            Navigate.angle(new SlotNavigationPoint((double)slotX, (double)slotY, null), mouseX, mouseY, 0.0);
        }

        private static boolean angle(NavigationPoint point, int mouseX, int mouseY, double offset) {
            double angle = Math.toDegrees(Math.atan2(point.getY() - (double)mouseY, point.getX() - (double)mouseX)) + offset;
            return angle > -45.0 && angle < 45.0;
        }
    }
}

