/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.gui.ControllerSelectionScreen;
import com.mrcrayfish.controllable.client.gui.widget.ControllerButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiEvents {
    private static final List<RenderGameOverlayEvent.ElementType> EXCLUDED_TYPES;
    private ControllerManager manager;

    public GuiEvents(ControllerManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onOpenGui(GuiScreenEvent.InitGuiEvent.Post event) {
        ButtonBinding.resetButtonStates();
        if (event.getGui() instanceof GuiOptions) {
            int y = event.getGui().field_146295_m / 6 + 72 - 6;
            event.getButtonList().add(new ControllerButton(event.getGui().field_146294_l / 2 + 5 + 150 + 4, y, button -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new ControllerSelectionScreen(this.manager, event.getGui()))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (Controllable.getOptions().useConsoleHotbar()) {
            if (EXCLUDED_TYPES.contains(event.getType())) {
                return;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-20.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (Controllable.getOptions().useConsoleHotbar()) {
            if (EXCLUDED_TYPES.contains(event.getType())) {
                return;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)20.0f, (float)0.0f);
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)RenderGameOverlayEvent.ElementType.ALL);
        builder.add((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH);
        builder.add((Object)RenderGameOverlayEvent.ElementType.BOSSINFO);
        builder.add((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS);
        builder.add((Object)RenderGameOverlayEvent.ElementType.DEBUG);
        builder.add((Object)RenderGameOverlayEvent.ElementType.FPS_GRAPH);
        builder.add((Object)RenderGameOverlayEvent.ElementType.HELMET);
        builder.add((Object)RenderGameOverlayEvent.ElementType.PLAYER_LIST);
        builder.add((Object)RenderGameOverlayEvent.ElementType.PORTAL);
        builder.add((Object)RenderGameOverlayEvent.ElementType.POTION_ICONS);
        builder.add((Object)RenderGameOverlayEvent.ElementType.SUBTITLES);
        builder.add((Object)RenderGameOverlayEvent.ElementType.VIGNETTE);
        EXCLUDED_TYPES = builder.build();
    }
}

