/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.IWidgetList;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ButtonBindingList
extends GuiListExtended {
    private ButtonBindingScreen screen;
    private final GuiListExtended.IGuiListEntry[] listEntries;
    private Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    public ButtonBindingList(ButtonBindingScreen screen, Minecraft mc, int widthIn, int heightIn, int topIn, int bottomIn, int itemHeightIn) {
        super(mc, widthIn, heightIn, topIn, bottomIn, itemHeightIn);
        this.screen = screen;
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        int size = 0;
        for (String entry : this.categories.keySet()) {
            List<ButtonBinding> bindings = this.categories.get(entry);
            if (bindings.isEmpty()) continue;
            ++size;
            size += this.categories.get(entry).size();
        }
        this.listEntries = new GuiListExtended.IGuiListEntry[size];
        int index = 0;
        for (String entry : this.categories.keySet()) {
            List<ButtonBinding> bindings = this.categories.get(entry);
            if (bindings.isEmpty()) continue;
            Collections.sort(bindings);
            this.listEntries[index++] = new CategoryEntry((ITextComponent)new TextComponentTranslation(entry, new Object[0]));
            for (ButtonBinding binding2 : bindings) {
                this.listEntries[index++] = new BindingEntry(binding2);
            }
        }
    }

    public boolean func_148179_a(int mouseX, int mouseY, int button) {
        if (this.screen.isWaitingForButtonInput()) {
            return true;
        }
        return super.func_148179_a(mouseX, mouseY, button);
    }

    @Nullable
    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        if (index >= 0 && index < this.func_148127_b()) {
            return this.listEntries[index];
        }
        return null;
    }

    protected int func_148127_b() {
        return this.listEntries.length;
    }

    protected class BindingEntry
    extends Entry {
        private ButtonBinding binding;
        private ITextComponent label;
        private ButtonBindingButton bindingButton;
        private ImageButton deleteButton;

        protected BindingEntry(ButtonBinding binding) {
            this.binding = binding;
            this.label = new TextComponentTranslation(binding.getDescription(), new Object[0]);
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> ButtonBindingList.this.screen.setSelectedBinding(this.binding));
            this.deleteButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                binding.reset();
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.resetBindingHash();
                registry.save();
            });
        }

        @Override
        public List<GuiButton> getWidgets() {
            return ImmutableList.of((Object)((Object)this.bindingButton), (Object)((Object)this.deleteButton));
        }

        @Override
        public void func_192634_a(int index, int left, int top, int width, int slotHeight, int mouseX, int mouseY, boolean selected, float partialTicks) {
            TextFormatting color = this.binding.isConflictingContext() ? TextFormatting.RED : TextFormatting.GRAY;
            this.label.func_150256_b().func_150238_a(color);
            ((ButtonBindingList)ButtonBindingList.this).field_148161_k.field_71466_p.func_78276_b(this.label.func_150254_d(), left - 15, top + 6, 0xFFFFFF);
            this.bindingButton.field_146128_h = left + width - 45;
            this.bindingButton.field_146129_i = top;
            this.bindingButton.func_191745_a(ButtonBindingList.this.field_148161_k, mouseX, mouseY, partialTicks);
            this.deleteButton.field_146128_h = left + width - 20;
            this.deleteButton.field_146129_i = top;
            this.deleteButton.field_146124_l = !this.binding.isDefault();
            this.deleteButton.func_191745_a(ButtonBindingList.this.field_148161_k, mouseX, mouseY, partialTicks);
        }

        @Override
        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int button, int relativeX, int relativeY) {
            if (this.bindingButton.field_146124_l && this.bindingButton.field_146125_m && this.bindingButton.func_146115_a()) {
                if (button == 0) {
                    this.bindingButton.func_146116_c(ButtonBindingList.this.field_148161_k, mouseX, mouseY);
                } else if (button == 1) {
                    this.binding.setButton(-1);
                }
                this.bindingButton.func_146113_a(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            if (this.deleteButton.field_146124_l && this.deleteButton.field_146125_m && this.deleteButton.func_146115_a()) {
                this.deleteButton.func_146116_c(ButtonBindingList.this.field_148161_k, mouseX, mouseY);
                this.bindingButton.func_146113_a(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            return super.func_148278_a(slotIndex, mouseX, mouseY, button, relativeX, relativeY);
        }
    }

    protected class CategoryEntry
    extends Entry {
        private final ITextComponent label;
        private final int labelWidth;

        protected CategoryEntry(ITextComponent label) {
            this.label = label;
            this.labelWidth = ((ButtonBindingList)ButtonBindingList.this).field_148161_k.field_71466_p.func_78256_a(this.label.func_150254_d());
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            int labelX = (int)((float)((ButtonBindingList)ButtonBindingList.this).field_148161_k.field_71462_r.field_146294_l / 2.0f - (float)this.labelWidth / 2.0f);
            int labelY = y + slotHeight - 9 - 1;
            ((ButtonBindingList)ButtonBindingList.this).field_148161_k.field_71466_p.func_78276_b(this.label.func_150254_d(), labelX, labelY, -1);
        }

        @Override
        public List<GuiButton> getWidgets() {
            return Collections.emptyList();
        }
    }

    abstract class Entry
    implements GuiListExtended.IGuiListEntry,
    IWidgetList {
        Entry() {
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }
    }
}

