/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.gui.widget.PressableButton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ControllerLayoutScreen
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private GuiScreen parentScreen;
    private LayoutButtonStates states = new LayoutButtonStates();
    private Mappings.Entry entry;
    private GuiButton doneButton;
    private GuiButton resetButton;
    private GuiButton thumbstickButton;

    protected ControllerLayoutScreen(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        Controller controller = Controllable.getController();
        if (controller != null) {
            Mappings.Entry entry = controller.getMapping();
            this.entry = entry != null ? entry.copy() : new Mappings.Entry(controller.getName(), controller.getName(), new HashMap<Integer, Integer>());
        }
    }

    public void func_73866_w_() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = this.func_189646_b(new PressableButton(this.field_146294_l / 2 - 154, this.field_146295_m - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.save", (Object[])new Object[0]), button -> {
            this.updateControllerMapping();
            this.field_146297_k.func_147108_a(this.parentScreen);
        }));
        this.resetButton = this.func_189646_b(new PressableButton(this.field_146294_l / 2 - 50, this.field_146295_m - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.reset", (Object[])new Object[0]), button -> {
            this.entry.getReassignments().clear();
            this.entry.setSwitchThumbsticks(false);
            this.entry.setFlipLeftX(false);
            this.entry.setFlipLeftY(false);
            this.entry.setFlipRightX(false);
            this.entry.setFlipRightY(false);
        }));
        this.func_189646_b(new PressableButton(this.field_146294_l / 2 + 54, this.field_146295_m - 32, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.field_146297_k.func_147108_a(this.parentScreen)));
        int width = 190;
        int x = this.field_146294_l / 2 - width / 2;
        int y = this.field_146295_m / 2 - 50 - 35;
        this.thumbstickButton = this.func_189646_b(new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> this.field_146297_k.func_147108_a((GuiScreen)new ThumbstickSettingsScreen(this))));
    }

    public void func_73876_c() {
        boolean changed = !this.entry.getReassignments().isEmpty();
        changed |= this.entry.isThumbsticksSwitched();
        changed |= this.entry.isFlipLeftX();
        changed |= this.entry.isFlipLeftY();
        changed |= this.entry.isFlipRightX();
        this.resetButton.field_146124_l = changed |= this.entry.isFlipRightY();
        this.validLayout = this.entry.getReassignments().values().stream().noneMatch(b -> b == -1);
        TextComponentTranslation save = new TextComponentTranslation("controllable.gui.save", new Object[0]);
        save.func_150256_b().func_150238_a(this.validLayout ? TextFormatting.WHITE : TextFormatting.RED);
        this.doneButton.field_146126_j = save.func_150254_d();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ArrayList<String> components;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 190;
        int height = 120;
        int x = this.field_146294_l / 2 - width / 2;
        int y = this.field_146295_m / 2 - 50 - 35;
        ControllerLayoutScreen.func_152125_a((int)x, (int)y, (float)50.0f, (float)0.0f, (int)38, (int)24, (int)width, (int)height, (float)256.0f, (float)256.0f);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(x, y, mouseX, mouseY, this.configureButton == controllerButton.button));
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"controllable.gui.title.layout", (Object[])new Object[0]), this.field_146294_l / 2, 20, 0xFFFFFF);
        TextComponentTranslation info = new TextComponentTranslation("controllable.gui.layout.info", new Object[0]);
        info.func_150256_b().func_150238_a(TextFormatting.GRAY);
        this.drawMultiLineCenteredString(this.field_146289_q, info.func_150254_d(), x + width / 2, y + 135, width + 190, -1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            GlStateManager.func_179097_i();
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"controllable.gui.layout.press_button", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2, -1);
            GlStateManager.func_179126_j();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<String>();
            TextComponentTranslation buttonName = new TextComponentTranslation(Buttons.NAMES[button.getButton()], new Object[0]);
            buttonName.func_150256_b().func_150238_a(TextFormatting.BLUE);
            components.add(I18n.func_135052_a((String)"controllable.gui.layout.button", (Object[])new Object[]{buttonName.func_150254_d()}));
            if (button.isMissingMapping()) {
                TextComponentTranslation missing = new TextComponentTranslation("controllable.gui.layout.missing_mapping", new Object[0]);
                missing.func_150256_b().func_150238_a(TextFormatting.RED);
                components.add(missing.func_150254_d());
            } else {
                int remappedButton = button.getButton();
                if (!button.isMissingMapping()) {
                    Map<Integer, Integer> reassignments = this.entry.getReassignments();
                    for (Integer key : reassignments.keySet()) {
                        if (reassignments.get(key) != remappedButton) continue;
                        remappedButton = key;
                        break;
                    }
                }
                TextComponentTranslation mapped = new TextComponentTranslation("controllable.gui.layout.mapped_to", new Object[]{new TextComponentString(String.valueOf(remappedButton))});
                mapped.func_150256_b().func_150238_a(TextFormatting.BLUE);
                components.add(mapped.func_150254_d());
            }
            TextComponentTranslation remap = new TextComponentTranslation("controllable.gui.layout.remap", new Object[0]);
            remap.func_150256_b().func_150238_a(TextFormatting.GRAY);
            components.add(remap.func_150254_d());
            this.func_146283_a(components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.func_146115_a()) {
            components = new ArrayList();
            TextComponentTranslation warning = new TextComponentTranslation("controllable.gui.layout.warning", new Object[0]);
            warning.func_150256_b().func_150238_a(TextFormatting.RED);
            components.add(warning.func_150254_d());
            TextComponentTranslation invalid = new TextComponentTranslation("controllable.gui.layout.invalid_layout", new Object[0]);
            invalid.func_150256_b().func_150238_a(TextFormatting.GRAY);
            components.addAll(this.field_146289_q.func_78271_c(invalid.func_150254_d(), 180));
            this.func_146283_a(components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)"controllable.gui.layout.thumbsticks", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ControllerButton button;
        if (mouseButton == 0 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.configureButton != -1) {
            this.configureButton = -1;
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean onButtonInput(int button) {
        if (this.configureButton != -1) {
            Map<Integer, Integer> reassignments = this.entry.getReassignments();
            if (button != this.configureButton) {
                reassignments.putIfAbsent(this.configureButton, -1);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != this.configureButton) continue;
                    reassignments.put(key, -1);
                }
                reassignments.put(button, this.configureButton);
            } else {
                reassignments.remove(button);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != button) continue;
                    reassignments.put(key, -1);
                }
            }
            this.configureButton = -1;
            return true;
        }
        return false;
    }

    private void updateControllerMapping() {
        Controller controller = Controllable.getController();
        if (controller != null) {
            controller.setMapping(this.entry);
            this.entry.save();
        }
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        if (state && this.onButtonInput(index)) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if ((index = this.remap(index)) == -1) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187883_gR, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187885_gS, (float)0.9f));
        }
    }

    public int remap(int button) {
        return this.entry.remap(button);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public Map<Integer, Integer> getReassignments() {
        return this.entry.getReassignments();
    }

    public Mappings.Entry getEntry() {
        return this.entry;
    }

    private void drawMultiLineCenteredString(FontRenderer font, String component, int x, int y, int width, int color) {
        for (String s : font.func_78271_c(component, width)) {
            font.func_78276_b(s, (int)((double)x - (double)font.func_78256_a(s) / 2.0), y, color);
            y += font.field_78288_b;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

