/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.gui.ControllerEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;

public class ControllerList
extends GuiListExtended {
    private ControllerManager manager;
    private List<ControllerEntry> controllers = new ArrayList<ControllerEntry>();

    public ControllerList(ControllerManager manager, Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.manager = manager;
        this.reload();
    }

    public void reload() {
        this.controllers.clear();
        Map<Integer, String> controllers = this.manager.getControllers();
        controllers.forEach((jid, name) -> this.controllers.add(new ControllerEntry(this, (int)jid)));
        this.updateSelected();
    }

    public void updateSelected() {
        Controller controller = Controllable.getController();
        if (controller == null) {
            this.field_148168_r = -1;
            return;
        }
        for (ControllerEntry entry : this.controllers) {
            if (entry.getJid() != controller.getJid()) continue;
            this.setSelected(entry);
            break;
        }
    }

    public void setSelected(GuiListExtended.IGuiListEntry entry) {
        int index = this.controllers.indexOf(entry);
        if (index != -1) {
            this.field_148168_r = index;
        }
    }

    public GuiListExtended.IGuiListEntry getSelected() {
        return this.func_148180_b(this.field_148168_r);
    }

    @Nullable
    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        if (index >= 0 && index < this.func_148127_b()) {
            return this.controllers.get(index);
        }
        return null;
    }

    protected int func_148127_b() {
        return this.controllers.size();
    }
}

