/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.settings;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ControllerType;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.settings.ControllableOptionBoolean;
import com.mrcrayfish.controllable.client.settings.ControllableOptionEnum;
import com.mrcrayfish.controllable.client.settings.ControllableOptionSlider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;

public class ControllerOptions {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0#");
    public static final ControllableOptionBoolean FORCE_FEEDBACK = new ControllableOptionBoolean("controllable.options.forceFeedback", () -> Controllable.getOptions().forceFeedback, value -> {
        Controllable.getOptions().forceFeedback = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.forceFeedback", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final ControllableOptionBoolean AUTO_SELECT = new ControllableOptionBoolean("controllable.options.autoSelect", () -> Controllable.getOptions().autoSelect, value -> {
        Controllable.getOptions().autoSelect = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.autoSelect", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final ControllableOptionBoolean RENDER_MINI_PLAYER = new ControllableOptionBoolean("controllable.options.renderMiniPlayer", () -> Controllable.getOptions().renderMiniPlayer, value -> {
        Controllable.getOptions().renderMiniPlayer = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.renderMiniPlayer", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final ControllableOptionBoolean VIRTUAL_MOUSE = new ControllableOptionBoolean("controllable.options.virtualMouse", () -> Controllable.getOptions().virtualMouse, value -> {
        Controllable.getOptions().virtualMouse = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.virtualMouse", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final ControllableOptionBoolean CONSOLE_HOTBAR = new ControllableOptionBoolean("controllable.options.consoleHotbar", () -> Controllable.getOptions().consoleHotbar, value -> {
        Controllable.getOptions().consoleHotbar = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.consoleHotbar", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final ControllableOptionEnum<CursorType> CURSOR_TYPE = new ControllableOptionEnum<CursorType>("controllable.options.cursorType", () -> Controllable.getOptions().cursorType, value -> {
        Controllable.getOptions().cursorType = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.cursorType", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("controllable.cursor." + value.func_176610_l()), (Object[])new Object[0]));
    public static final ControllableOptionEnum<ControllerType> CONTROLLER_TYPE = new ControllableOptionEnum<ControllerType>("controllable.options.controllerType", () -> Controllable.getOptions().controllerType, value -> {
        Controllable.getOptions().controllerType = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.controllerType", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("controllable.controller." + value.func_176610_l()), (Object[])new Object[0]));
    public static final ControllableOptionBoolean INVERT_LOOK = new ControllableOptionBoolean("controllable.options.invertLook", () -> Controllable.getOptions().invertLook, value -> {
        Controllable.getOptions().invertLook = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.invertLook", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final ControllableOptionSlider DEAD_ZONE = new ControllableOptionSlider("controllable.options.deadZone", 0.01f, 0.0f, 1.0f, () -> Controllable.getOptions().deadZone, value -> {
        Controllable.getOptions().deadZone = MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
    }, value -> {
        double deadZone = Controllable.getOptions().deadZone;
        return I18n.func_135052_a((String)"controllable.options.deadZone.format", (Object[])new Object[]{FORMAT.format(deadZone)});
    });
    public static final ControllableOptionSlider ROTATION_SPEED = new ControllableOptionSlider("controllable.options.rotationSpeed", 1.0f, 1.0f, 50.0f, () -> Controllable.getOptions().rotationSpeed, value -> {
        Controllable.getOptions().rotationSpeed = MathHelper.func_151237_a((double)value, (double)1.0, (double)50.0);
    }, value -> {
        double rotationSpeed = Controllable.getOptions().rotationSpeed;
        return I18n.func_135052_a((String)"controllable.options.rotationSpeed.format", (Object[])new Object[]{FORMAT.format(rotationSpeed)});
    });
    public static final ControllableOptionSlider MOUSE_SPEED = new ControllableOptionSlider("controllable.options.mouseSpeed", 1.0f, 1.0f, 50.0f, () -> Controllable.getOptions().mouseSpeed, value -> {
        Controllable.getOptions().mouseSpeed = MathHelper.func_151237_a((double)value, (double)1.0, (double)50.0);
    }, value -> {
        double mouseSpeed = Controllable.getOptions().mouseSpeed;
        return I18n.func_135052_a((String)"controllable.options.mouseSpeed.format", (Object[])new Object[]{FORMAT.format(mouseSpeed)});
    });
    public static final ControllableOptionEnum<ActionVisibility> SHOW_ACTIONS = new ControllableOptionEnum<ActionVisibility>("controllable.options.showActions", () -> Controllable.getOptions().actionVisibility, value -> {
        Controllable.getOptions().actionVisibility = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.showActions.format", (Object[])new Object[]{I18n.func_135052_a((String)("controllable.actionVisibility." + value.func_176610_l()), (Object[])new Object[0])}));
    public static final ControllableOptionBoolean QUICK_CRAFT = new ControllableOptionBoolean("controllable.options.quickCraft", () -> Controllable.getOptions().quickCraft, value -> {
        Controllable.getOptions().quickCraft = value;
    }, value -> I18n.func_135052_a((String)"controllable.options.quickCraft", (Object[])new Object[0]) + ": " + (value != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0])));
    public static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private Minecraft minecraft;
    private File optionsFile;
    private boolean forceFeedback = true;
    private boolean autoSelect = true;
    private boolean renderMiniPlayer = true;
    private boolean virtualMouse = true;
    private boolean consoleHotbar = false;
    private CursorType cursorType = CursorType.LIGHT;
    private ControllerType controllerType = ControllerType.DEFAULT;
    private boolean invertLook = false;
    private double deadZone = 0.15;
    private double rotationSpeed = 25.0;
    private double mouseSpeed = 30.0;
    private ActionVisibility actionVisibility = ActionVisibility.MINIMAL;
    private boolean quickCraft = true;

    public ControllerOptions(Minecraft minecraft, File dataDir) {
        this.minecraft = minecraft;
        this.optionsFile = new File(dataDir, "controllable-options.txt");
        this.loadOptions();
    }

    private void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            List lines = IOUtils.readLines((InputStream)new FileInputStream(this.optionsFile), (Charset)Charsets.UTF_8);
            NBTTagCompound compound = new NBTTagCompound();
            for (String line : lines) {
                try {
                    Iterator iterator = COLON_SPLITTER.omitEmptyStrings().limit(2).split((CharSequence)line).iterator();
                    compound.func_74778_a((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception var10) {
                    Controllable.LOGGER.warn("Skipping bad option: {}", (Object)line);
                }
            }
            for (String key : compound.func_150296_c()) {
                String value = compound.func_74779_i(key);
                try {
                    switch (key) {
                        case "forceFeedback": {
                            this.forceFeedback = Boolean.valueOf(value);
                            break;
                        }
                        case "autoSelect": {
                            this.autoSelect = Boolean.valueOf(value);
                            break;
                        }
                        case "cursorType": {
                            this.cursorType = CursorType.byId(value);
                            break;
                        }
                        case "controllerType": {
                            this.controllerType = ControllerType.byName(value);
                            break;
                        }
                        case "invertLook": {
                            this.invertLook = Boolean.valueOf(value);
                            break;
                        }
                        case "deadZone": {
                            this.deadZone = Double.parseDouble(value);
                            break;
                        }
                        case "virtualMouse": {
                            this.virtualMouse = Boolean.valueOf(value);
                            break;
                        }
                        case "consoleHotbar": {
                            this.consoleHotbar = Boolean.valueOf(value);
                            break;
                        }
                        case "rotationSpeed": {
                            this.rotationSpeed = Double.parseDouble(value);
                            break;
                        }
                        case "mouseSpeed": {
                            this.mouseSpeed = Double.parseDouble(value);
                            break;
                        }
                        case "renderMiniPlayer": {
                            this.renderMiniPlayer = Boolean.valueOf(value);
                        }
                    }
                }
                catch (Exception e) {
                    Controllable.LOGGER.warn("Skipping bad option: {}:{}", (Object)key, (Object)value);
                }
            }
        }
        catch (Exception e) {
            Controllable.LOGGER.error("Failed to load options", (Throwable)e);
        }
    }

    public void saveOptions() {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFile), StandardCharsets.UTF_8));){
            writer.println("forceFeedback:" + this.forceFeedback);
            writer.println("autoSelect:" + this.autoSelect);
            writer.println("renderMiniPlayer:" + this.renderMiniPlayer);
            writer.println("virtualMouse:" + this.virtualMouse);
            writer.println("consoleHotbar:" + this.consoleHotbar);
            writer.println("cursorType:" + this.cursorType.func_176610_l());
            writer.println("controllerType:" + this.controllerType.func_176610_l());
            writer.println("invertLook:" + this.invertLook);
            writer.println("deadZone:" + FORMAT.format(this.deadZone));
            writer.println("rotationSpeed:" + FORMAT.format(this.rotationSpeed));
            writer.println("mouseSpeed:" + FORMAT.format(this.mouseSpeed));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean useForceFeedback() {
        return this.forceFeedback;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public boolean isRenderMiniPlayer() {
        return this.renderMiniPlayer;
    }

    public boolean isVirtualMouse() {
        return this.virtualMouse;
    }

    public boolean useConsoleHotbar() {
        return this.consoleHotbar;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public ControllerType getControllerType() {
        return this.controllerType;
    }

    public boolean isInvertLook() {
        return this.invertLook;
    }

    public double getDeadZone() {
        return this.deadZone;
    }

    public double getRotationSpeed() {
        return this.rotationSpeed;
    }

    public double getMouseSpeed() {
        return this.mouseSpeed;
    }

    public ActionVisibility getActionVisibility() {
        return this.actionVisibility;
    }

    public boolean isQuickCraft() {
        return this.quickCraft;
    }
}

