/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.event;

import com.mrcrayfish.controllable.client.Controller;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class ControllerEvent
extends Event {
    private Controller controller;

    public ControllerEvent(Controller controller) {
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    @Cancelable
    public static class Turn
    extends ControllerEvent {
        private float yawSpeed;
        private float pitchSpeed;

        public Turn(Controller controller, float yawSpeed, float pitchSpeed) {
            super(controller);
            this.yawSpeed = yawSpeed;
            this.pitchSpeed = pitchSpeed;
        }

        public float getYawSpeed() {
            return this.yawSpeed;
        }

        public void setYawSpeed(float yawSpeed) {
            this.yawSpeed = yawSpeed;
        }

        public float getPitchSpeed() {
            return this.pitchSpeed;
        }

        public void setPitchSpeed(float pitchSpeed) {
            this.pitchSpeed = pitchSpeed;
        }
    }

    @Cancelable
    public static class Move
    extends ControllerEvent {
        public Move(Controller controller) {
            super(controller);
        }
    }

    @Cancelable
    public static class Button
    extends ControllerEvent {
        public Button(Controller controller) {
            super(controller);
        }
    }

    @Cancelable
    public static class ButtonInput
    extends ControllerEvent {
        private int originalButton;
        private int button;
        private boolean state;

        public ButtonInput(Controller controller, int button, boolean state) {
            super(controller);
            this.originalButton = button;
            this.button = button;
            this.state = state;
        }

        public int getButton() {
            return this.originalButton;
        }

        public int getModifiedButton() {
            return this.button;
        }

        public void setButton(int button) {
            this.button = button;
        }

        public boolean getState() {
            return this.state;
        }
    }
}

