/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.libsdl.SDL;
import org.libsdl.SDL_Error;
import org.libsdl.SDL_GameControllerID;

public final class SDL_GameController {
    long ptr;
    final float AXIS_MIN;
    final float AXIS_MAX;

    SDL_GameController(long ptr) {
        this.ptr = ptr;
        this.AXIS_MAX = SDL.SDL_JOYSTICK_AXIS_MAX();
        this.AXIS_MIN = SDL.SDL_JOYSTICK_AXIS_MIN();
    }

    public void close() {
        if (this.ptr != 0L) {
            SDL.SDL_GameControllerClose(this.ptr);
            this.ptr = 0L;
        }
    }

    public boolean getAttached() {
        return this.ptr != 0L && SDL.SDL_GameControllerGetAttached(this.ptr);
    }

    public float getAxis(int axis) {
        if (!this.getAttached()) {
            return 0.0f;
        }
        int i = SDL.SDL_GameControllerGetAxis(this.ptr, axis);
        if (i < 0) {
            return (float)i / -this.AXIS_MIN;
        }
        return (float)i / this.AXIS_MAX;
    }

    public boolean getButton(int button) {
        return this.getAttached() && SDL.SDL_GameControllerGetButton(this.ptr, button) == 1;
    }

    public String name() {
        return SDL.SDL_GameControllerName(this.ptr);
    }

    public static boolean addMappingsFromFile(String path, Class sourceClass) throws IOException, IllegalStateException, SDL_Error {
        Path extractedLoc = Files.createTempFile(null, null, new FileAttribute[0]).toAbsolutePath();
        InputStream source = null;
        if (sourceClass != null) {
            try {
                source = sourceClass.getResourceAsStream(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (source == null) {
            source = ClassLoader.getSystemResourceAsStream(path);
        }
        if (source == null) {
            throw new IOException("Cannot open resource from classpath " + path);
        }
        Files.copy(source, extractedLoc, StandardCopyOption.REPLACE_EXISTING);
        System.out.println("EXTRACTED LOC " + extractedLoc.toString());
        int result = SDL.SDL_GameControllerAddMappingsFromFile(extractedLoc.toString());
        Files.delete(extractedLoc);
        return SDL_GameController.intToBoolean(result);
    }

    public static boolean addMappingsFromFile(String path) throws IOException, IllegalStateException, SDL_Error {
        return SDL_GameController.addMappingsFromFile(path, null);
    }

    public boolean addMapping(String mappingString) throws SDL_Error {
        return SDL_GameController.intToBoolean(SDL.SDL_GameControllerAddMapping(mappingString));
    }

    public static boolean eventStateQuery() throws SDL_Error {
        return SDL_GameController.eventState(-1);
    }

    public static boolean eventStateIgnore() throws SDL_Error {
        return SDL_GameController.eventState(0);
    }

    public static boolean eventStateEnable() throws SDL_Error {
        return SDL_GameController.eventState(1);
    }

    private static boolean eventState(int i) throws SDL_Error {
        return SDL_GameController.intToBoolean(SDL.SDL_GameControllerEventState(i));
    }

    private static boolean intToBoolean(int i) throws SDL_Error {
        if (i > 0) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        throw new SDL_Error();
    }

    public static SDL_GameController GameControllerFromInstanceID(SDL_GameControllerID joyid) {
        return new SDL_GameController(SDL.SDL_GameControllerFromInstanceID(joyid.id));
    }

    public static SDL_GameController SDL_GameControllerFromPlayerIndex(int player_index) {
        return new SDL_GameController(SDL.SDL_GameControllerFromPlayerIndex(player_index));
    }

    public static String GameControllerNameForIndex(int device_index) {
        return SDL.SDL_GameControllerNameForIndex(device_index);
    }

    public int getType() {
        return SDL.SDL_GameControllerGetType(this.ptr);
    }

    public int getPlayerIndex() {
        return SDL.SDL_GameControllerGetPlayerIndex(this.ptr);
    }

    public void setPlayerIndex(int player_index) {
        SDL.SDL_GameControllerSetPlayerIndex(this.ptr, player_index);
    }

    public static SDL_GameController GameControllerOpen(int i) {
        return new SDL_GameController(SDL.SDL_GameControllerOpen(i));
    }

    public static void GameControllerUpdate() {
        SDL.SDL_GameControllerUpdate();
    }

    public boolean isGameController(int joystick_index) {
        return SDL.SDL_IsGameController(joystick_index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDL_GameController that = (SDL_GameController)o;
        return this.ptr == that.ptr;
    }

    public int hashCode() {
        return Objects.hash(this.ptr);
    }
}

