/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.sdl2gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerManager;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import org.libsdl.SDL;
import org.libsdl.SDL_Error;
import org.libsdl.SDL_GameController;
import org.libsdl.SDL_Joystick;
import uk.co.electronstudio.sdl2gdx.SDL2Controller;

public class SDL2ControllerManager
implements ControllerManager {
    private final Array<Controller> controllers = new Array();
    private final Array<Controller> polledControllers = new Array();
    private final IntArray connectedInstanceIds = new IntArray(128);
    private final Array<ControllerListener> listeners = new Array();
    private boolean running = true;

    public SDL2ControllerManager() {
        this(SDL2ControllerManager.getInputPreferenceProperty());
    }

    private static InputPreference getInputPreferenceProperty() {
        String ip = System.getProperty("SDL.input");
        if (ip == null) {
            return InputPreference.XINPUT;
        }
        switch (ip) {
            case "XINPUT": {
                return InputPreference.XINPUT;
            }
            case "RAW_INPUT": {
                return InputPreference.RAW_INPUT;
            }
            case "DIRECT_INPUT": {
                return InputPreference.DIRECT_INPUT;
            }
        }
        return InputPreference.XINPUT;
    }

    public SDL2ControllerManager(InputPreference inputPreference) {
        SDL.SDL_SetHint("SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", "1");
        SDL.SDL_SetHint("SDL_ACCELEROMETER_AS_JOYSTICK", "0");
        SDL.SDL_SetHint("SDL_MAC_BACKGROUND_APP", "1");
        switch (inputPreference) {
            case XINPUT: {
                SDL.SDL_SetHint("SDL_XINPUT_ENABLED", "1");
                SDL.SDL_SetHint("SDL_JOYSTICK_RAWINPUT", "0");
                break;
            }
            case RAW_INPUT: {
                SDL.SDL_SetHint("SDL_XINPUT_ENABLED", "1");
                SDL.SDL_SetHint("SDL_JOYSTICK_RAWINPUT", "1");
                break;
            }
            case DIRECT_INPUT: {
                SDL.SDL_SetHint("SDL_XINPUT_ENABLED", "0");
                SDL.SDL_SetHint("SDL_JOYSTICK_RAWINPUT", "0");
            }
        }
        if (SDL.SDL_Init(SDL.SDL_INIT_EVENTS | SDL.SDL_INIT_JOYSTICK | SDL.SDL_INIT_GAMECONTROLLER) != 0) {
            throw new RuntimeException("SDL_Init failed: " + SDL.SDL_GetError());
        }
        try {
            SDL_GameController.addMappingsFromFile("/gamecontrollerdb.txt", this.getClass());
        }
        catch (Exception e) {
            System.out.println("Failed to load gamecontrollerdb.txt");
            e.printStackTrace();
        }
        try {
            for (int i = 0; i < SDL_Joystick.numJoysticks(); ++i) {
                String name = SDL_Joystick.joystickNameForIndex(i);
                System.out.printf("Joystick %d: %s\n", i, name != null ? name : "Unknown Joystick");
                this.connected(new SDL2Controller(this, i));
            }
        }
        catch (SDL_Error e) {
            e.printStackTrace();
        }
        if (Gdx.app != null) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (!SDL2ControllerManager.this.running) {
                        return;
                    }
                    try {
                        SDL2ControllerManager.this.pollState();
                    }
                    catch (SDL_Error e) {
                        e.printStackTrace();
                    }
                    Gdx.app.postRunnable(this);
                }
            });
        }
    }

    public void pollState() throws SDL_Error {
        SDL.SDL_PumpEvents();
        for (int i = 0; i < SDL_Joystick.numJoysticks(); ++i) {
            int id = SDL.SDL_JoystickGetDeviceInstanceID(i);
            if (this.connectedInstanceIds.contains(id)) continue;
            this.connected(new SDL2Controller(this, i));
        }
        this.polledControllers.addAll(this.controllers);
        for (Controller controller : this.polledControllers) {
            SDL2Controller c = (SDL2Controller)controller;
            if (c.isConnected()) {
                c.pollState();
                continue;
            }
            this.disconnected(c);
        }
        this.polledControllers.clear();
    }

    @Override
    public Array<Controller> getControllers() {
        return this.controllers;
    }

    @Override
    public void addListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    public void addListenerAndRunForConnectedControllers(ControllerListener listener) {
        for (Controller controller : this.controllers) {
            listener.connected(controller);
        }
        this.addListener(listener);
    }

    @Override
    public void removeListener(ControllerListener listener) {
        this.listeners.removeValue(listener, true);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    private void connected(SDL2Controller controller) {
        System.out.println("connected " + controller);
        this.controllers.add(controller);
        this.connectedInstanceIds.add(controller.joystick.instanceID().id);
        for (ControllerListener listener : this.listeners) {
            listener.connected(controller);
        }
    }

    private void disconnected(SDL2Controller controller) {
        System.out.println("disconnected " + controller);
        this.controllers.removeValue(controller, false);
        this.connectedInstanceIds.removeValue(controller.joystick.instanceID().id);
        for (ControllerListener listener : this.listeners) {
            listener.disconnected(controller);
        }
        controller.close();
    }

    void axisChanged(SDL2Controller controller, int axisCode, float value) {
        for (ControllerListener listener : this.listeners) {
            listener.axisMoved(controller, axisCode, value);
        }
    }

    void buttonChanged(SDL2Controller controller, int buttonCode, boolean value) {
        for (ControllerListener listener : this.listeners) {
            if (value) {
                listener.buttonDown(controller, buttonCode);
                continue;
            }
            listener.buttonUp(controller, buttonCode);
        }
    }

    void hatChanged(SDL2Controller controller, int hatCode, PovDirection value) {
        for (ControllerListener listener : this.listeners) {
            listener.povMoved(controller, hatCode, value);
        }
    }

    @Override
    public Array<ControllerListener> getListeners() {
        return this.listeners;
    }

    public void close() {
        this.running = false;
        SDL.SDL_Quit();
    }

    public static enum InputPreference {
        XINPUT,
        DIRECT_INPUT,
        RAW_INPUT;

    }
}

