/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.corpsecomplex.common.CommonEventHandler;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;
import top.theillusivec4.corpsecomplex.common.modules.effects.EffectsModule;
import top.theillusivec4.corpsecomplex.common.modules.experience.ExperienceModule;
import top.theillusivec4.corpsecomplex.common.modules.hunger.HungerModule;
import top.theillusivec4.corpsecomplex.common.modules.inventory.InventoryModule;
import top.theillusivec4.corpsecomplex.common.modules.mementomori.MementoMoriModule;
import top.theillusivec4.corpsecomplex.common.modules.miscellaneous.MiscellaneousModule;
import top.theillusivec4.corpsecomplex.common.util.integration.IntegrationManager;
import top.theillusivec4.corpsecomplex.common.util.manager.DeathConditionManager;
import top.theillusivec4.corpsecomplex.common.util.manager.DeathOverrideManager;
import top.theillusivec4.corpsecomplex.common.util.manager.ItemOverrideManager;

@Mod(value="corpsecomplex")
public class CorpseComplex {
    public static final String MODID = "corpsecomplex";
    public static final Logger LOGGER = LogManager.getLogger();

    public CorpseComplex() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CorpseComplexConfig.SERVER_SPEC);
        CorpseComplex.createServerConfig(CorpseComplexConfig.OVERRIDES_SPEC, "overrides");
        CorpseComplex.createServerConfig(CorpseComplexConfig.ITEM_OVERRIDES_SPEC, "itemoverrides");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::config);
        MinecraftForge.EVENT_BUS.register((Object)new InventoryModule());
        MinecraftForge.EVENT_BUS.register((Object)new ExperienceModule());
        MinecraftForge.EVENT_BUS.register((Object)new HungerModule());
        MinecraftForge.EVENT_BUS.register((Object)new EffectsModule());
        MinecraftForge.EVENT_BUS.register((Object)new MementoMoriModule());
        MinecraftForge.EVENT_BUS.register((Object)new MiscellaneousModule());
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
    }

    private void setup(FMLCommonSetupEvent evt) {
        DeathStorageCapability.register();
        IntegrationManager.init();
    }

    private void config(ModConfig.ModConfigEvent evt) {
        ModConfig modConfig = evt.getConfig();
        if (modConfig.getModId().equals(MODID)) {
            ForgeConfigSpec spec = modConfig.getSpec();
            if (modConfig.getType() == ModConfig.Type.SERVER) {
                CorpseComplexConfig.bakeConfigs();
                if (spec == CorpseComplexConfig.OVERRIDES_SPEC) {
                    CorpseComplexConfig.transformOverrides(modConfig.getConfigData());
                    DeathConditionManager.importConfig();
                    DeathOverrideManager.importConfig();
                } else if (spec == CorpseComplexConfig.ITEM_OVERRIDES_SPEC) {
                    CorpseComplexConfig.transformItemOverrides(modConfig.getConfigData());
                    ItemOverrideManager.importConfig();
                }
            }
        }
    }

    private static void createServerConfig(ForgeConfigSpec spec, String suffix) {
        String fileName = "corpsecomplex-" + suffix + ".toml";
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, spec, fileName);
        File defaults = new File(FMLPaths.GAMEDIR.get() + "/defaultconfigs/" + fileName);
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(CorpseComplex.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                LOGGER.error("Error creating default config for " + fileName);
            }
        }
    }
}

