/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.effects;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.modules.effects.EffectsSetting;
import top.theillusivec4.corpsecomplex.common.util.Enums;

public class EffectsModule {
    @SubscribeEvent
    public void finishItemUse(LivingEntityUseItemEvent.Finish evt) {
        LivingEntity entity = evt.getEntityLiving();
        if (!entity.func_130014_f_().func_201670_d() && entity instanceof PlayerEntity) {
            DeathStorageCapability.getCapability((PlayerEntity)entity).ifPresent(deathStorage -> deathStorage.getSettings().getEffectsSettings().getCures().forEach(itemStack -> {
                if (ItemStack.func_179545_c((ItemStack)evt.getItem(), (ItemStack)itemStack)) {
                    entity.curePotionEffects(evt.getItem());
                }
            }));
        }
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)evt.getEntityLiving();
        World world = playerEntity.func_130014_f_();
        if (!world.func_201670_d()) {
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> playerEntity.func_70651_bq().forEach(effectInstance -> {
                EffectsSetting setting = deathStorage.getSettings().getEffectsSettings();
                List<Effect> keepEffects = setting.getKeepEffects();
                boolean flag = setting.getKeepEffectsMode() == Enums.PermissionMode.BLACKLIST ? !keepEffects.contains(effectInstance.func_188419_a()) : keepEffects.contains(effectInstance.func_188419_a());
                if (flag) {
                    deathStorage.addEffectInstance((EffectInstance)effectInstance);
                }
            }));
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone evt) {
        if (evt.isWasDeath()) {
            DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> DeathStorageCapability.getCapability(evt.getOriginal()).ifPresent(oldDeathStorage -> oldDeathStorage.getEffects().forEach(deathStorage::addEffectInstance)));
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        if (!evt.isEndConquered()) {
            PlayerEntity player = evt.getPlayer();
            DeathStorageCapability.getCapability(player).ifPresent(deathStorage -> {
                deathStorage.getEffects().forEach(arg_0 -> ((PlayerEntity)player).func_195064_c(arg_0));
                deathStorage.clearEffects();
                deathStorage.getSettings().getEffectsSettings().getEffects().forEach(effectInstance -> {
                    EffectInstance newEffect = new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b(), effectInstance.func_76458_c());
                    newEffect.setCurativeItems(effectInstance.getCurativeItems());
                    player.func_195064_c(newEffect);
                });
            });
        }
    }
}

