/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.experience;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.modules.experience.ExperienceSetting;
import top.theillusivec4.corpsecomplex.common.util.Enums;

public class ExperienceModule {
    @SubscribeEvent
    public void playerXpDrop(LivingExperienceDropEvent evt) {
        if (evt.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)evt.getEntityLiving();
            DeathStorageCapability.getCapability(player).ifPresent(deathStorage -> {
                double lose = deathStorage.getSettings().getExperienceSettings().getLostXp();
                if (lose <= 0.0) {
                    evt.setCanceled(true);
                    return;
                }
                int totalPoints = ExperienceModule.getExperiencePoints(player);
                int level = player.field_71068_ca;
                int lostPoints = (int)(lose * (double)totalPoints);
                int keptXp = totalPoints - lostPoints;
                player.field_71106_cc = 0.0f;
                player.field_71067_cb = 0;
                player.field_71068_ca = 0;
                player.func_195068_e(keptXp);
                int lostLevels = player.field_71068_ca - level;
                int droppedXp = ExperienceModule.getDroppedExperiencePoints(player, lostLevels, lostPoints, deathStorage);
                evt.setDroppedExperience(droppedXp);
            });
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.Clone evt) {
        if (evt.isWasDeath()) {
            PlayerEntity playerEntity = evt.getPlayer();
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> {
                PlayerEntity original = evt.getOriginal();
                if (deathStorage.getSettings().getExperienceSettings().getLostXp() < 1.0) {
                    playerEntity.field_71106_cc = original.field_71106_cc;
                    playerEntity.field_71068_ca = original.field_71068_ca;
                    playerEntity.field_71067_cb = original.field_71067_cb;
                }
            });
        }
    }

    private static int getExperiencePointsFromLevel(int levels) {
        int points = 0;
        points = levels <= 16 ? (points += levels * levels + 6 * levels) : (levels <= 31 ? (int)((float)points + ((float)(levels * levels) * 2.5f - (float)levels * 40.5f + 360.0f)) : (int)((float)points + ((float)(levels * levels) * 4.5f - (float)levels * 162.5f + 2220.0f)));
        return points;
    }

    private static float getLevelsFromExperiencePoints(int points) {
        int levels = points < 394 ? (int)(-3.0 + Math.sqrt(points + 9)) : (points < 1628 ? (int)(8.1 + 0.1 * Math.sqrt(40 * points - 7839)) : (int)(18.0556 + 0.0555556 * Math.sqrt(72 * points - 54215)));
        return levels;
    }

    private static int getExperiencePoints(PlayerEntity player) {
        int points = (int)((float)player.func_71050_bK() * player.field_71106_cc);
        return points + ExperienceModule.getExperiencePointsFromLevel(player.field_71068_ca);
    }

    private static int getDroppedExperiencePoints(PlayerEntity player, int lostLevels, int lostPoints, DeathStorageCapability.IDeathStorage deathStorage) {
        if (!player.func_175149_v()) {
            ExperienceSetting setting = deathStorage.getSettings().getExperienceSettings();
            int i = setting.getXpDropMode() == Enums.XpDropMode.PER_LEVEL ? lostLevels * setting.getDroppedXpPerLevel() : (int)((double)lostPoints * setting.getDroppedXpPercent());
            return Math.min(i, setting.getMaxDroppedXp());
        }
        return 0;
    }
}

