/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.hunger;

import java.lang.reflect.Field;
import net.minecraft.util.FoodStats;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.corpsecomplex.CorpseComplex;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.modules.hunger.HungerSetting;

public class HungerModule {
    private static final Field SATURATION_LEVEL = ObfuscationReflectionHelper.findField(FoodStats.class, (String)"field_75125_b");
    private static final Field EXHAUSTION_LEVEL = ObfuscationReflectionHelper.findField(FoodStats.class, (String)"field_75126_c");

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.Clone evt) {
        if (evt.isWasDeath()) {
            DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> {
                FoodStats stats = evt.getPlayer().func_71024_bL();
                FoodStats oldStats = evt.getOriginal().func_71024_bL();
                HungerSetting setting = deathStorage.getSettings().getHungerSettings();
                int minFood = setting.getMinFood();
                int maxFood = setting.getMaxFood();
                if (maxFood < minFood) {
                    CorpseComplex.LOGGER.error("Config error: minFood cannot be greater than maxFood!");
                } else {
                    int food = setting.isKeepFood() ? oldStats.func_75116_a() : 20;
                    stats.func_75114_a(Math.max(minFood, Math.min(maxFood, food)));
                }
                if (setting.isKeepSaturation()) {
                    try {
                        SATURATION_LEVEL.setFloat(stats, oldStats.func_75115_e());
                    }
                    catch (IllegalAccessException e) {
                        CorpseComplex.LOGGER.error("Error setting saturation level!");
                    }
                }
                if (setting.isKeepExhaustion()) {
                    try {
                        float exhaustion = EXHAUSTION_LEVEL.getFloat(oldStats);
                        EXHAUSTION_LEVEL.setFloat(stats, exhaustion);
                    }
                    catch (IllegalAccessException e) {
                        CorpseComplex.LOGGER.error("Error setting exhaustion level!");
                    }
                }
            });
        }
    }
}

