/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.inventory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import top.theillusivec4.corpsecomplex.common.config.ConfigParser;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;
import top.theillusivec4.corpsecomplex.common.modules.Setting;
import top.theillusivec4.corpsecomplex.common.modules.inventory.InventoryOverride;
import top.theillusivec4.corpsecomplex.common.util.Enums;

public class InventorySetting
implements Setting<InventoryOverride> {
    private Map<Enums.InventorySection, SectionSettings> inventorySettings = new HashMap<Enums.InventorySection, SectionSettings>();
    private Map<Item, Enums.DropMode> items = new HashMap<Item, Enums.DropMode>();
    private boolean limitDurabilityLoss;
    private int dropDespawnTime;

    public Map<Enums.InventorySection, SectionSettings> getInventorySettings() {
        return this.inventorySettings;
    }

    public void setInventorySettings(Map<Enums.InventorySection, SectionSettings> inventorySettings) {
        this.inventorySettings = inventorySettings;
    }

    public Map<Item, Enums.DropMode> getItems() {
        return this.items;
    }

    public void setItems(Map<Item, Enums.DropMode> items) {
        this.items = items;
    }

    public boolean isLimitDurabilityLoss() {
        return this.limitDurabilityLoss;
    }

    public void setLimitDurabilityLoss(boolean limitDurabilityLoss) {
        this.limitDurabilityLoss = limitDurabilityLoss;
    }

    public int getDropDespawnTime() {
        return this.dropDespawnTime;
    }

    public void setDropDespawnTime(int dropDespawnTime) {
        this.dropDespawnTime = dropDespawnTime;
    }

    @Override
    public void importConfig() {
        this.getInventorySettings().clear();
        this.getInventorySettings().put(Enums.InventorySection.DEFAULT, new SectionSettings(CorpseComplexConfig.keepChance, CorpseComplexConfig.destroyChance, CorpseComplexConfig.keepDurabilityLoss, CorpseComplexConfig.dropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.MAINHAND, new SectionSettings(CorpseComplexConfig.mainhandKeepChance, CorpseComplexConfig.mainhandDestroyChance, CorpseComplexConfig.mainhandKeepDurabilityLoss, CorpseComplexConfig.mainhandDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.OFFHAND, new SectionSettings(CorpseComplexConfig.offhandKeepChance, CorpseComplexConfig.offhandDestroyChance, CorpseComplexConfig.offhandKeepDurabilityLoss, CorpseComplexConfig.offhandDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.HOTBAR, new SectionSettings(CorpseComplexConfig.hotbarKeepChance, CorpseComplexConfig.hotbarDestroyChance, CorpseComplexConfig.hotbarKeepDurabilityLoss, CorpseComplexConfig.hotbarDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.MAIN, new SectionSettings(CorpseComplexConfig.mainKeepChance, CorpseComplexConfig.mainDestroyChance, CorpseComplexConfig.mainKeepDurabilityLoss, CorpseComplexConfig.mainDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.HEAD, new SectionSettings(CorpseComplexConfig.headKeepChance, CorpseComplexConfig.headDestroyChance, CorpseComplexConfig.headKeepDurabilityLoss, CorpseComplexConfig.headDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.CHEST, new SectionSettings(CorpseComplexConfig.chestKeepChance, CorpseComplexConfig.chestDestroyChance, CorpseComplexConfig.chestKeepDurabilityLoss, CorpseComplexConfig.chestDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.LEGS, new SectionSettings(CorpseComplexConfig.legsKeepChance, CorpseComplexConfig.legsDestroyChance, CorpseComplexConfig.legsKeepDurabilityLoss, CorpseComplexConfig.legsDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.FEET, new SectionSettings(CorpseComplexConfig.feetKeepChance, CorpseComplexConfig.feetDestroyChance, CorpseComplexConfig.feetKeepDurabilityLoss, CorpseComplexConfig.feetDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.CURIOS, new SectionSettings(CorpseComplexConfig.curioKeepChance, CorpseComplexConfig.curioDestroyChance, CorpseComplexConfig.curioKeepDurabilityLoss, CorpseComplexConfig.curioDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.COSMETIC_ARMOR, new SectionSettings(CorpseComplexConfig.cosmeticArmorKeepChance, CorpseComplexConfig.cosmeticArmorDestroyChance, CorpseComplexConfig.cosmeticArmorKeepDurabilityLoss, CorpseComplexConfig.cosmeticArmorDropDurabilityLoss));
        this.getInventorySettings().put(Enums.InventorySection.TOOL_BELT, new SectionSettings(CorpseComplexConfig.toolBeltKeepChance, CorpseComplexConfig.toolBeltDestroyChance, 0.0, 0.0));
        this.setItems(ConfigParser.parseDrops(CorpseComplexConfig.itemSettings));
        this.setLimitDurabilityLoss(CorpseComplexConfig.limitDurabilityLoss);
        this.setDropDespawnTime(CorpseComplexConfig.dropDespawnTime);
    }

    @Override
    public void applyOverride(InventoryOverride override) {
        override.getInventorySettings().ifPresent(map -> Arrays.asList(Enums.InventorySection.values()).forEach(section -> {
            InventoryOverride.SectionSettings overrideSection = (InventoryOverride.SectionSettings)map.get(section);
            SectionSettings inventorySection = this.getInventorySettings().get(section);
            if (overrideSection != null) {
                overrideSection.getDestroyChance().ifPresent(setting -> {
                    inventorySection.destroyChance = setting;
                });
                overrideSection.getKeepChance().ifPresent(setting -> {
                    inventorySection.keepChance = setting;
                });
                overrideSection.getDropDurabilityLoss().ifPresent(setting -> {
                    inventorySection.dropDurabilityLoss = setting;
                });
                overrideSection.getKeepDurabilityLoss().ifPresent(setting -> {
                    inventorySection.keepDurabilityLoss = setting;
                });
            }
        }));
        override.getItems().ifPresent(this::setItems);
        override.getLimitDurabilityLoss().ifPresent(this::setLimitDurabilityLoss);
        override.getDropDespawnTime().ifPresent(this::setDropDespawnTime);
    }

    public static class SectionSettings {
        public double keepChance;
        public double destroyChance;
        public double keepDurabilityLoss;
        public double dropDurabilityLoss;

        public SectionSettings(double keepChance, double destroyChance, double keepDurabilityLoss, double dropDurabilityLoss) {
            this.keepChance = keepChance;
            this.destroyChance = destroyChance;
            this.keepDurabilityLoss = keepDurabilityLoss;
            this.dropDurabilityLoss = dropDurabilityLoss;
        }
    }
}

