/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.inventory.inventories.integration;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.modules.inventory.InventorySetting;
import top.theillusivec4.corpsecomplex.common.modules.inventory.inventories.Inventory;
import top.theillusivec4.corpsecomplex.common.util.Enums;
import top.theillusivec4.corpsecomplex.common.util.InventoryHelper;

public class ToolBeltInventory
implements Inventory {
    @Override
    public void storeInventory(DeathStorageCapability.IDeathStorage deathStorage) {
        ItemStack belt;
        PlayerEntity playerEntity = deathStorage.getPlayer();
        if (ConfigData.customBeltSlotEnabled && !(belt = BeltFinder.findBelt((PlayerEntity)playerEntity).map(BeltFinder.BeltGetter::getBelt).orElse(ItemStack.field_190927_a)).func_190926_b()) {
            Random random;
            double destroyChance;
            InventorySetting setting = deathStorage.getSettings().getInventorySettings();
            Enums.DropMode inventoryRule = InventoryHelper.getDropModeOverride(belt, setting);
            InventorySetting.SectionSettings defaultSettings = setting.getInventorySettings().get((Object)Enums.InventorySection.DEFAULT);
            InventorySetting.SectionSettings sectionSettings = setting.getInventorySettings().get((Object)Enums.InventorySection.TOOL_BELT);
            double keepChance = sectionSettings.keepChance >= 0.0 ? sectionSettings.keepChance : defaultSettings.keepChance;
            double d = destroyChance = sectionSettings.destroyChance >= 0.0 ? sectionSettings.destroyChance : defaultSettings.destroyChance;
            if (inventoryRule != null) {
                if (inventoryRule == Enums.DropMode.KEEP) {
                    keepChance = 1.0;
                } else if (inventoryRule == Enums.DropMode.DESTROY) {
                    destroyChance = 1.0;
                } else if (inventoryRule == Enums.DropMode.DROP) {
                    keepChance = 0.0;
                }
            }
            if ((random = new Random()).nextDouble() < keepChance) {
                deathStorage.addInventory("tool_belt", (INBT)belt.serializeNBT());
                belt.func_190918_g(1);
            } else if (random.nextDouble() < destroyChance) {
                belt.func_190918_g(1);
            }
        }
    }

    @Override
    public void retrieveInventory(DeathStorageCapability.IDeathStorage newStorage, DeathStorageCapability.IDeathStorage oldStorage) {
        CompoundNBT tag;
        PlayerEntity player = newStorage.getPlayer();
        PlayerEntity oldPlayer = oldStorage.getPlayer();
        if (player != null && oldPlayer != null && (tag = (CompoundNBT)oldStorage.getInventory("tool_belt")) != null) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
            BeltFinder.setFinderSlotContents((PlayerEntity)player, (String)"belt_slot", (int)0, (ItemStack)stack);
        }
    }
}

