/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.mementomori;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.CakeBlock;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;
import top.theillusivec4.corpsecomplex.common.modules.mementomori.MementoMoriEffect;
import top.theillusivec4.corpsecomplex.common.registry.CorpseComplexRegistry;

public class MementoMoriModule {
    private static final List<ItemStack> CURES = new ArrayList<ItemStack>();

    @SubscribeEvent
    public void serverStart(FMLServerStartedEvent evt) {
        if ((Integer)CorpseComplexConfig.SERVER.healthMod.get() != 0) {
            MementoMoriEffect.ATTRIBUTES.put(Attributes.field_233818_a_, new MementoMoriEffect.AttributeInfo(((Integer)CorpseComplexConfig.SERVER.healthMod.get()).intValue(), UUID.fromString("ca572ca7-d11e-4054-b225-f4c797cdf69b"), AttributeModifier.Operation.ADDITION));
        }
        if ((Integer)CorpseComplexConfig.SERVER.armorMod.get() != 0) {
            MementoMoriEffect.ATTRIBUTES.put(Attributes.field_233826_i_, new MementoMoriEffect.AttributeInfo(((Integer)CorpseComplexConfig.SERVER.armorMod.get()).intValue(), UUID.fromString("b3bd0150-1953-4971-a822-8445953c4195"), AttributeModifier.Operation.ADDITION));
        }
        if ((Integer)CorpseComplexConfig.SERVER.toughnessMod.get() != 0) {
            MementoMoriEffect.ATTRIBUTES.put(Attributes.field_233827_j_, new MementoMoriEffect.AttributeInfo(((Integer)CorpseComplexConfig.SERVER.toughnessMod.get()).intValue(), UUID.fromString("5113ef1e-5200-4d6a-a898-946f0e4b5d26"), AttributeModifier.Operation.ADDITION));
        }
        if ((Double)CorpseComplexConfig.SERVER.movementMod.get() != 0.0) {
            MementoMoriEffect.ATTRIBUTES.put(Attributes.field_233821_d_, new MementoMoriEffect.AttributeInfo((Double)CorpseComplexConfig.SERVER.movementMod.get(), UUID.fromString("f9a9495d-89b5-4676-8345-bc2e92936821"), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((Double)CorpseComplexConfig.SERVER.attackSpeedMod.get() != 0.0) {
            MementoMoriEffect.ATTRIBUTES.put(Attributes.field_233825_h_, new MementoMoriEffect.AttributeInfo((Double)CorpseComplexConfig.SERVER.attackSpeedMod.get(), UUID.fromString("9fe627b8-3477-4ccf-9587-87776259172f"), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((Double)CorpseComplexConfig.SERVER.damageMod.get() != 0.0) {
            MementoMoriEffect.ATTRIBUTES.put(Attributes.field_233823_f_, new MementoMoriEffect.AttributeInfo((Double)CorpseComplexConfig.SERVER.damageMod.get(), UUID.fromString("ae5b003a-65f3-41f2-b104-4c71a2261d5b"), AttributeModifier.Operation.ADDITION));
        }
        ((List)CorpseComplexConfig.SERVER.mementoCures.get()).forEach(cure -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(cure));
            if (item != null) {
                CURES.add(new ItemStack((IItemProvider)item));
            }
        });
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        PlayerEntity playerEntity = evt.getPlayer();
        if (!MementoMoriEffect.ATTRIBUTES.isEmpty() || ((Boolean)CorpseComplexConfig.SERVER.noFood.get()).booleanValue() || (Double)CorpseComplexConfig.SERVER.percentXp.get() != 0.0) {
            EffectInstance instance = new EffectInstance(CorpseComplexRegistry.MEMENTO_MORI, (Integer)CorpseComplexConfig.SERVER.duration.get() * 20);
            instance.setCurativeItems(CURES);
            playerEntity.func_195064_c(instance);
            if (playerEntity.func_110143_aJ() < playerEntity.func_110138_aP()) {
                playerEntity.func_70606_j(playerEntity.func_110138_aP());
            }
        }
    }

    @SubscribeEvent
    public void eatingFood(PlayerInteractEvent.RightClickItem evt) {
        DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> {
            if (evt.getPlayer().func_70644_a(CorpseComplexRegistry.MEMENTO_MORI) && deathStorage.getSettings().getMementoMoriSettings().isNoFood() && evt.getItemStack().func_77975_n() == UseAction.EAT) {
                evt.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void eatingCake(PlayerInteractEvent.RightClickBlock evt) {
        DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> {
            if (evt.getPlayer().func_70644_a(CorpseComplexRegistry.MEMENTO_MORI) && deathStorage.getSettings().getMementoMoriSettings().isNoFood() && evt.getWorld().func_180495_p(evt.getPos()).func_177230_c() instanceof CakeBlock) {
                evt.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void playerChangeXp(PlayerXpEvent.XpChange evt) {
        DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> {
            double percentXp;
            PlayerEntity playerEntity = evt.getPlayer();
            EffectInstance effectInstance = playerEntity.func_70660_b(CorpseComplexRegistry.MEMENTO_MORI);
            if (effectInstance != null && (percentXp = deathStorage.getSettings().getMementoMoriSettings().getPercentXp()) != 0.0) {
                double modifier = CorpseComplexConfig.gradualRecovery ? (double)((float)effectInstance.func_76459_b() / (float)CorpseComplexConfig.duration) : 1.0;
                evt.setAmount(Math.max(1, (int)((double)evt.getAmount() * (1.0 + (percentXp *= modifier)))));
            }
        });
    }
}

