/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class DeathInfo {
    private String damageType;
    private boolean isFireDamage;
    private boolean isMagicDamage;
    private boolean isExplosion;
    private boolean isProjectile;
    @Nullable
    private EntityType<?> immediateSource;
    @Nullable
    private EntityType<?> trueSource;
    private ResourceLocation dimension;
    private List<String> gameStages;

    public DeathInfo() {
    }

    public DeathInfo(DamageSource source, World world, @Nonnull List<String> gameStages) {
        this.damageType = source.func_76355_l();
        this.isFireDamage = source.func_76347_k();
        this.isMagicDamage = source.func_82725_o();
        this.isExplosion = source.func_94541_c();
        this.isProjectile = source.func_76352_a();
        this.immediateSource = source.func_76364_f() != null ? source.func_76364_f().func_200600_R() : null;
        this.trueSource = source.func_76346_g() != null ? source.func_76346_g().func_200600_R() : null;
        this.dimension = world.func_234923_W_().getRegistryName();
        this.gameStages = gameStages;
    }

    public String getDamageType() {
        return this.damageType;
    }

    public boolean isFireDamage() {
        return this.isFireDamage;
    }

    public boolean isMagicDamage() {
        return this.isMagicDamage;
    }

    public boolean isExplosion() {
        return this.isExplosion;
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }

    @Nullable
    public EntityType<?> getImmediateSource() {
        return this.immediateSource;
    }

    @Nullable
    public EntityType<?> getTrueSource() {
        return this.trueSource;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public List<String> getGameStages() {
        return this.gameStages;
    }

    public CompoundNBT write(CompoundNBT compoundNBT) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("DamageType", this.damageType);
        tag.func_74757_a("FireDamage", this.isFireDamage);
        tag.func_74757_a("MagicDamage", this.isMagicDamage);
        tag.func_74757_a("Explosion", this.isExplosion);
        tag.func_74757_a("Projectile", this.isProjectile);
        if (this.immediateSource != null && this.immediateSource.getRegistryName() != null) {
            tag.func_74778_a("ImmediateSource", this.immediateSource.getRegistryName().toString());
        }
        if (this.trueSource != null && this.trueSource.getRegistryName() != null) {
            tag.func_74778_a("TrueSource", this.trueSource.getRegistryName().toString());
        }
        tag.func_74778_a("Dimension", this.dimension.toString());
        ListNBT list = new ListNBT();
        this.gameStages.forEach(stage -> list.add((Object)StringNBT.func_229705_a_((String)stage)));
        tag.func_218657_a("GameStages", (INBT)list);
        compoundNBT.func_218657_a("DeathDamageSource", (INBT)tag);
        return compoundNBT;
    }

    public void read(CompoundNBT compoundNBT) {
        CompoundNBT tag = compoundNBT.func_74775_l("DeathDamageSource");
        this.damageType = tag.func_74779_i("DamageType");
        this.isFireDamage = tag.func_74767_n("FireDamage");
        this.isMagicDamage = tag.func_74767_n("MagicDamage");
        this.isExplosion = tag.func_74767_n("Explosion");
        this.isProjectile = tag.func_74767_n("Projectile");
        if (tag.func_74764_b("ImmediateSource")) {
            this.immediateSource = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.func_74779_i("ImmediateSource")));
        }
        if (tag.func_74764_b("TrueSource")) {
            this.trueSource = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.func_74779_i("TrueSource")));
        }
        this.dimension = new ResourceLocation(tag.func_74779_i("Dimension"));
        this.gameStages = new ArrayList<String>();
        ListNBT list = tag.func_150295_c("GameStages", 8);
        list.forEach(stage -> this.gameStages.add(stage.func_150285_a_()));
    }
}

