/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.util.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.corpsecomplex.CorpseComplex;
import top.theillusivec4.corpsecomplex.common.DeathCondition;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;
import top.theillusivec4.corpsecomplex.common.util.DeathInfo;

public class DeathConditionManager {
    public static final Map<String, DeathCondition> CONDITIONS = new HashMap<String, DeathCondition>();
    public static final List<BiFunction<DeathInfo, DeathCondition, Boolean>> CONDITION_ADDONS = new ArrayList<BiFunction<DeathInfo, DeathCondition, Boolean>>();

    public static boolean matches(DeathCondition deathCondition, DeathStorageCapability.IDeathStorage deathStorage) {
        String uuid;
        String name;
        DeathInfo source = deathStorage.getDeathInfo();
        if (source == null) {
            return false;
        }
        for (BiFunction<DeathInfo, DeathCondition, Boolean> conditionAddon : CONDITION_ADDONS) {
            if (conditionAddon.apply(source, deathCondition).booleanValue()) continue;
            return false;
        }
        PlayerEntity playerEntity = deathStorage.getPlayer();
        Optional<List<String>> playersOpt = deathCondition.getPlayers();
        boolean matchesPlayer = playersOpt.map(arg_0 -> DeathConditionManager.lambda$matches$1(name = playerEntity.func_200200_C_().getString(), uuid = playerEntity.func_110124_au().toString(), arg_0)).orElse(true);
        if (!matchesPlayer) {
            return false;
        }
        Optional<Difficulty> difficultyOpt = deathCondition.getDifficulty();
        boolean matchesDifficulty = difficultyOpt.map(difficulty -> playerEntity.func_130014_f_().func_175659_aa() == difficulty).orElse(true);
        if (!matchesDifficulty) {
            return false;
        }
        Optional<String> damageTypeOpt = deathCondition.getDamageType();
        boolean matchesDamage = damageTypeOpt.map(damageType -> {
            if (source.getDamageType().equals(damageType)) {
                return true;
            }
            if (source.isFireDamage() && damageType.equals("fire")) {
                return true;
            }
            if (source.isMagicDamage() && damageType.equals("magic")) {
                return true;
            }
            if (source.isExplosion() && damageType.equals("explosion")) {
                return true;
            }
            return source.isProjectile() && damageType.equals("projectile");
        }).orElse(true);
        if (!matchesDamage) {
            return false;
        }
        Optional<ResourceLocation> dimensionOpt = deathCondition.getDimension();
        boolean matchesDimension = dimensionOpt.map(dimension -> source.getDimension().equals(dimension)).orElse(true);
        if (!matchesDimension) {
            return false;
        }
        Optional<EntityType<?>> imSrcOpt = deathCondition.getImmediateSource();
        boolean matchesImSrc = imSrcOpt.map(immediateSource -> {
            EntityType<?> imSrc = source.getImmediateSource();
            return imSrc == immediateSource;
        }).orElse(true);
        if (!matchesImSrc) {
            return false;
        }
        Optional<EntityType<?>> trueSrcOpt = deathCondition.getTrueSource();
        return trueSrcOpt.map(trueSource -> {
            EntityType<?> trueSrc = source.getTrueSource();
            return trueSrc == trueSource;
        }).orElse(true);
    }

    public static void importConfig() {
        CONDITIONS.clear();
        CorpseComplexConfig.conditions.forEach(condition -> {
            String identifier = condition.identifier;
            if (identifier == null) {
                CorpseComplex.LOGGER.error("Missing identifier in conditions! Skipping...");
                return;
            }
            ResourceLocation dimensionLocation = null;
            if (condition.dimension != null && !condition.dimension.isEmpty()) {
                dimensionLocation = new ResourceLocation(condition.dimension);
            }
            DeathCondition.Builder builder = new DeathCondition.Builder().damageType(condition.damageType).immediateSource(DeathConditionManager.getEntityType(condition.immediateSource)).trueSource(DeathConditionManager.getEntityType(condition.trueSource)).dimension(dimensionLocation).gameStages(condition.gameStages).difficulty(DeathConditionManager.getDifficulty(condition.difficulty)).players(condition.players);
            CONDITIONS.put(identifier, builder.build());
        });
    }

    public static Difficulty getDifficulty(@Nullable String difficulty) {
        return difficulty == null ? null : Difficulty.func_219963_a((String)difficulty);
    }

    public static EntityType<?> getEntityType(@Nullable String name) {
        return name == null ? null : (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
    }

    private static /* synthetic */ Boolean lambda$matches$1(String name, String uuid, List players) {
        return players.stream().anyMatch(player -> name.equals(player) || uuid.equals(player));
    }
}

