/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.impl.data.ByteArrayData;
import com.blamejared.crafttweaker.impl.data.ByteData;
import com.blamejared.crafttweaker.impl.data.IntArrayData;
import com.blamejared.crafttweaker.impl.data.IntData;
import com.blamejared.crafttweaker.impl.data.ListData;
import com.blamejared.crafttweaker.impl.data.LongArrayData;
import com.blamejared.crafttweaker.impl.data.LongData;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.data.ICollectionData")
@Document(value="vanilla/api/data/ICollectionData")
public interface ICollectionData
extends IData {
    @ZenCodeType.Method
    public static ICollectionData getFromMembers(IData ... members) {
        if (Arrays.stream(members).allMatch(member -> member instanceof ByteData)) {
            byte[] result = new byte[members.length];
            for (int i = 0; i < members.length; ++i) {
                result[i] = members[i].asNumber().getByte();
            }
            return new ByteArrayData(result);
        }
        if (Arrays.stream(members).allMatch(member -> member instanceof ByteData || member instanceof IntData)) {
            int[] result = new int[members.length];
            for (int i = 0; i < members.length; ++i) {
                result[i] = members[i].asNumber().getInt();
            }
            return new IntArrayData(result);
        }
        if (Arrays.stream(members).allMatch(member -> member instanceof ByteData || member instanceof IntData || member instanceof LongData)) {
            long[] result = new long[members.length];
            for (int i = 0; i < members.length; ++i) {
                result[i] = members[i].asNumber().getLong();
            }
            return new LongArrayData(result);
        }
        return new ListData(members);
    }

    @ZenCodeType.Method
    public IData setAt(int var1, IData var2);

    @ZenCodeType.Method
    public void add(int var1, IData var2);

    @ZenCodeType.Method
    public void add(IData var1);

    @ZenCodeType.Method
    public IData remove(int var1);

    @ZenCodeType.Method
    public IData getAt(int var1);

    @ZenCodeType.Getter(value="size")
    public int size();

    @ZenCodeType.Method
    public void clear();

    @Override
    default public String toJsonString() {
        return this.asList().stream().map(IData::toJsonString).collect(Collectors.joining(",", "[", "]"));
    }
}

