/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;

public abstract class ActionBrewingBase
implements IUndoableAction {
    protected final List<IBrewingRecipe> recipes;
    private Field inputField;
    private Field reagentField;
    private Field outputField;

    protected ActionBrewingBase(List<IBrewingRecipe> recipes) {
        this.recipes = recipes;
        try {
            Class<?> mixPredicate = Class.forName("net.minecraft.potion.PotionBrewing$MixPredicate");
            this.inputField = ObfuscationReflectionHelper.findField(mixPredicate, (String)"field_185198_a");
            this.inputField.setAccessible(true);
            this.reagentField = ObfuscationReflectionHelper.findField(mixPredicate, (String)"field_185199_b");
            this.reagentField.setAccessible(true);
            this.outputField = ObfuscationReflectionHelper.findField(mixPredicate, (String)"field_185200_c");
            this.outputField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Ingredient getItemReagent(Object mixInstance) {
        try {
            return (Ingredient)this.reagentField.get(mixInstance);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IRegistryDelegate<Potion> getPotionInput(Object mixInstance) {
        try {
            return (IRegistryDelegate)this.inputField.get(mixInstance);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IRegistryDelegate<Potion> getPotionOutput(Object mixInstance) {
        try {
            return (IRegistryDelegate)this.outputField.get(mixInstance);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

