/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ActionRemoveBrewingRecipe
extends ActionBrewingBase {
    private final List<IBrewingRecipe> removedRecipes = new ArrayList<IBrewingRecipe>();
    private final IItemStack input;
    private final IItemStack output;
    private final IItemStack reagentStack;

    public ActionRemoveBrewingRecipe(List<IBrewingRecipe> recipes, IItemStack output, IItemStack reagentStack, IItemStack input) {
        super(recipes);
        this.output = output;
        this.reagentStack = reagentStack;
        this.input = input;
    }

    @Override
    public void apply() {
        Iterator registryIterator = this.recipes.iterator();
        while (registryIterator.hasNext()) {
            IBrewingRecipe next = (IBrewingRecipe)registryIterator.next();
            ItemStack recipeOutput = next.getOutput(this.input.getInternal(), this.reagentStack.getInternal());
            if (recipeOutput.func_190926_b() || !this.output.matches(new MCItemStackMutable(recipeOutput))) continue;
            this.removedRecipes.add(next);
            registryIterator.remove();
        }
    }

    @Override
    public void undo() {
        this.removedRecipes.forEach(BrewingRecipeRegistry::addRecipe);
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + this.input + ", output of: " + this.output + " and a reagent of: " + this.reagentStack;
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + this.input + ", output of: " + this.output + " and a reagent of: " + this.reagentStack;
    }
}

