/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.impl_native.potion.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByPotionInput
extends ActionBrewingBase {
    private final List removed = new ArrayList();
    private final Potion input;

    public ActionRemoveBrewingRecipeByPotionInput(List<IBrewingRecipe> recipes, Potion input) {
        super(recipes);
        this.input = input;
    }

    @Override
    public void apply() {
        Iterator iterator = PotionBrewing.field_185213_a.iterator();
        while (iterator.hasNext()) {
            Object mix = iterator.next();
            IRegistryDelegate<Potion> potionInput = this.getPotionInput(mix);
            if (potionInput == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!((Potion)potionInput.get()).getRegistryName().equals((Object)this.input.getRegistryName())) continue;
            this.removed.add(mix);
            iterator.remove();
        }
    }

    @Override
    public void undo() {
        for (Object o : this.removed) {
            IRegistryDelegate<Potion> potionInput = this.getPotionInput(o);
            Ingredient itemReagent = this.getItemReagent(o);
            IRegistryDelegate<Potion> potionOutput = this.getPotionOutput(o);
            if (potionInput == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.logError("Error getting mix entries! potionInput: %s, itemReagent: %s, potionOutput: %s", potionInput, itemReagent, potionOutput);
                continue;
            }
            PotionBrewing.func_193357_a((Potion)((Potion)potionInput.get()), (Item)itemReagent.func_193365_a()[0].func_77973_b(), (Potion)((Potion)potionOutput.get()));
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input);
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input);
    }
}

