/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items.tooltips;

import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import com.blamejared.crafttweaker.impl.events.CTClientEventHandler;
import java.util.LinkedList;
import net.minecraftforge.fml.LogicalSide;

public class ActionModifyTooltip
implements IRuntimeAction {
    private final IIngredient stack;
    private final ITooltipFunction function;

    public ActionModifyTooltip(IIngredient stack, ITooltipFunction function) {
        this.stack = stack;
        this.function = function;
    }

    @Override
    public void apply() {
        CTClientEventHandler.TOOLTIPS.computeIfAbsent(this.stack, iItemStack -> new LinkedList()).add(this.function);
    }

    @Override
    public String describe() {
        return "Adding advanced tooltip to: " + this.stack.getCommandString();
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return side.isClient();
    }
}

