/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items.tooltips;

import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.events.CTClientEventHandler;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import net.minecraftforge.fml.LogicalSide;

public class ActionRemoveRegexTooltip
implements IRuntimeAction {
    private final IIngredient stack;
    private final Pattern regex;

    public ActionRemoveRegexTooltip(IIngredient stack, Pattern regex) {
        this.stack = stack;
        this.regex = regex;
    }

    @Override
    public void apply() {
        CTClientEventHandler.TOOLTIPS.computeIfAbsent(this.stack, iItemStack -> new LinkedList()).add((stack1, tooltip, isAdvanced) -> {
            ArrayList<MCTextComponent> content = new ArrayList<MCTextComponent>();
            for (MCTextComponent component : tooltip) {
                if (this.regex.matcher(component.getFormattedText()).find()) continue;
                content.add(component);
            }
            tooltip.clear();
            tooltip.addAll(content);
        });
    }

    @Override
    public String describe() {
        return "Removing from the tooltip for: " + this.stack.getCommandString() + " based on the regex: \"" + this.regex + "\"";
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return side.isClient();
    }
}

