/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.logger;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class PlayerLogger
implements ILogger {
    private static final Map<LogLevel, Pair<Style, Style>> STYLING = (Map)Util.func_200696_a(new EnumMap(LogLevel.class), map -> {
        map.put(LogLevel.ERROR, PlayerLogger.make(TextFormatting.DARK_RED.func_211163_e(), TextFormatting.RED.func_211163_e()));
        map.put(LogLevel.WARNING, PlayerLogger.make(TextFormatting.GOLD.func_211163_e(), TextFormatting.YELLOW.func_211163_e()));
        map.put(LogLevel.INFO, PlayerLogger.make(TextFormatting.DARK_GREEN.func_211163_e(), TextFormatting.GREEN.func_211163_e()));
        map.put(LogLevel.DEBUG, PlayerLogger.make(TextFormatting.DARK_PURPLE.func_211163_e(), TextFormatting.LIGHT_PURPLE.func_211163_e()));
        map.put(LogLevel.TRACE, PlayerLogger.make(TextFormatting.DARK_GRAY.func_211163_e(), TextFormatting.GRAY.func_211163_e()));
    });
    private PlayerEntity player;
    private LogLevel logLevel = LogLevel.WARNING;

    public PlayerLogger(PlayerEntity player) {
        this.player = player;
    }

    private static Pair<Style, Style> make(Integer header, Integer content) {
        return Pair.of((Object)(header == null ? Style.field_240709_b_ : Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)header))), (Object)(content == null ? Style.field_240709_b_ : Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)content))));
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        if (logLevel.canLog(LogLevel.WARNING)) {
            this.logLevel = logLevel;
        }
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void log(LogLevel level, String message, boolean prefix) {
        if (this.logLevel.canLog(level)) {
            Pair<Style, Style> styling = STYLING.get((Object)level);
            IFormattableTextComponent header = new StringTextComponent("[" + (Object)((Object)level) + "] ").func_230530_a_((Style)styling.getFirst());
            IFormattableTextComponent line = header.func_230529_a_((ITextComponent)new StringTextComponent(message).func_230530_a_((Style)styling.getSecond()));
            this.player.func_145747_a((ITextComponent)line, CraftTweaker.CRAFTTWEAKER_UUID);
        }
    }

    @Override
    public void throwingErr(String message, Throwable throwable) {
        this.error(String.format("%s: %s", message, throwable.getMessage()));
    }

    @Override
    public void throwingWarn(String message, Throwable throwable) {
        this.warning(String.format("%s: %s", message, throwable.getMessage()));
    }
}

