/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.modifiers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.api.loot.modifiers.ILootModifier;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraftforge.common.loot.LootModifier;

public final class CTLootModifier
extends LootModifier {
    private final String name;
    private final Predicate<LootContext> conditions;
    private final ILootModifier function;

    public CTLootModifier(String name, List<ILootCondition> conditions, ILootModifier function) {
        super(new net.minecraft.loot.conditions.ILootCondition[0]);
        this.name = name;
        this.conditions = context -> conditions.stream().allMatch(it -> it.test((LootContext)context));
        this.function = function;
    }

    public CTLootModifier(String name, ILootCondition[] conditions, ILootModifier function) {
        this(name, conditions == null ? Collections.emptyList() : Arrays.asList(conditions), function);
    }

    @Nonnull
    public final List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        List<IItemStack> wrappedLoot = CraftTweakerHelper.getIItemStacks(generatedLoot);
        if (!this.conditions.test(context)) {
            return generatedLoot;
        }
        try {
            return CraftTweakerHelper.getItemStacks(this.function.applyModifier(wrappedLoot, context));
        }
        catch (Exception e) {
            CraftTweakerAPI.logThrowing("An error occurred while trying to run loot modifier '%s': %s", e, this.name, e.getMessage());
            return generatedLoot;
        }
    }
}

