/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.modifiers;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifiers.ILootModifier;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.modifiers.MCLootModifier")
@Document(value="vanilla/api/loot/modifiers/MCLootModifier")
public final class MCLootModifier
implements ILootModifier {
    private final IGlobalLootModifier internal;

    public MCLootModifier(IGlobalLootModifier internal) {
        this.internal = internal == null ? DummyGlobalLootModifier.INSTANCE : internal;
    }

    public IGlobalLootModifier getInternal() {
        return this.internal;
    }

    @Override
    public List<IItemStack> applyModifier(List<IItemStack> loot, LootContext currentContext) {
        if (this.internal == DummyGlobalLootModifier.INSTANCE) {
            return loot;
        }
        List<ItemStack> unwrappedLoot = CraftTweakerHelper.getItemStacks(loot);
        return CraftTweakerHelper.getIItemStacks(this.internal.apply(unwrappedLoot, currentContext));
    }

    private static final class DummyGlobalLootModifier
    implements IGlobalLootModifier {
        private static final DummyGlobalLootModifier INSTANCE = new DummyGlobalLootModifier();

        private DummyGlobalLootModifier() {
        }

        public List<ItemStack> apply(List<ItemStack> generatedLoot, LootContext context) {
            return generatedLoot;
        }
    }
}

