/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Objects;
import net.minecraft.advancements.criterion.MinMaxBounds;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.IntRangePredicate")
@Document(value="vanilla/api/predicate/IntRangePredicate")
public final class IntRangePredicate
extends IVanillaWrappingPredicate.AnyDefaulting<MinMaxBounds.IntBound> {
    private static final IntRangePredicate UNBOUNDED = new IntRangePredicate(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final int min;
    private final int max;

    private IntRangePredicate(int min, int max) {
        super(MinMaxBounds.IntBound.field_211347_e);
        this.min = min;
        this.max = max;
    }

    public static IntRangePredicate unbounded() {
        return UNBOUNDED;
    }

    public static IntRangePredicate lowerBounded(int min) {
        return new IntRangePredicate(min, Integer.MAX_VALUE);
    }

    public static IntRangePredicate upperBounded(int max) {
        return new IntRangePredicate(Integer.MIN_VALUE, max);
    }

    public static IntRangePredicate bounded(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum IntRange bound must not be more than maximum bound");
        }
        return new IntRangePredicate(min, max);
    }

    public static IntRangePredicate mergeLowerBound(IntRangePredicate previous, int min) {
        if (previous == null) {
            return IntRangePredicate.lowerBounded(min);
        }
        return IntRangePredicate.bounded(min, previous.getMax());
    }

    public static IntRangePredicate mergeUpperBound(IntRangePredicate previous, int max) {
        if (previous == null) {
            return IntRangePredicate.upperBounded(max);
        }
        return IntRangePredicate.bounded(previous.getMin(), max);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean match(int target) {
        return this.min <= target && target <= this.max;
    }

    @Override
    public boolean isAny() {
        return this == UNBOUNDED;
    }

    @Override
    public MinMaxBounds.IntBound toVanilla() {
        return new MinMaxBounds.IntBound(Integer.valueOf(this.min), Integer.valueOf(this.max));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntRangePredicate that = (IntRangePredicate)o;
        return this.getMin() == that.getMin() && this.getMax() == that.getMax();
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public String toString() {
        return this.getMin() + ".." + this.getMax();
    }
}

