/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.handlers.vanilla;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

@IRecipeHandler.For(value=ShapedRecipe.class)
public final class ShapedRecipeHandler
implements IRecipeHandler<ShapedRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, ShapedRecipe recipe) {
        NonNullList ingredients = recipe.func_192400_c();
        return String.format("craftingTable.addShaped(%s, %s, %s);", StringUtils.quoteAndEscape(recipe.func_199560_c()), new MCItemStackMutable(recipe.func_77571_b()).getCommandString(), IntStream.range(0, recipe.getRecipeHeight()).mapToObj(y -> IntStream.range(0, recipe.getRecipeWidth()).mapToObj(x -> (Ingredient)ingredients.get(y * recipe.getRecipeWidth() + x)).map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]")));
    }

    @Override
    public Optional<Function<ResourceLocation, ShapedRecipe>> replaceIngredients(IRecipeManager manager, ShapedRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.func_192400_c(), Ingredient.class, recipe, rules, newIngredients -> id -> new ShapedRecipe(id, recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), newIngredients, recipe.func_77571_b()));
    }
}

