/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionReplaceRecipe;
import com.blamejared.crafttweaker.impl.managers.GenericRecipesManager;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class ReplacerAction
implements IRuntimeAction {
    private final ITargetingRule targetingRule;
    private final List<IReplacementRule> replacementRules;
    private final Collection<ResourceLocation> defaultExclusions;
    private final Function<ResourceLocation, ResourceLocation> generatorFunction;
    private final boolean suppressWarnings;

    public ReplacerAction(ITargetingRule targetingRule, List<IReplacementRule> replacementRules, Collection<ResourceLocation> defaultExclusions, Function<ResourceLocation, ResourceLocation> generatorFunction, boolean suppressWarnings) {
        this.targetingRule = targetingRule;
        this.replacementRules = replacementRules;
        this.defaultExclusions = ReplacerAction.filter(targetingRule, defaultExclusions);
        this.generatorFunction = generatorFunction;
        this.suppressWarnings = suppressWarnings;
    }

    private static Collection<ResourceLocation> filter(ITargetingRule rule, Collection<ResourceLocation> fullExclusions) {
        Map<ResourceLocation, WrapperRecipe> map = GenericRecipesManager.RECIPES.getRecipeMap();
        return (Collection)Util.func_200696_a(new HashSet<ResourceLocation>(fullExclusions), set -> set.removeIf(it -> {
            WrapperRecipe recipe = (WrapperRecipe)map.get(it);
            return !rule.shouldBeReplaced(recipe.getRecipe(), recipe.getManager());
        }));
    }

    @Override
    public void apply() {
        GenericRecipesManager.RECIPES.getAllRecipes().stream().filter(it -> !this.defaultExclusions.contains(it.getId())).map(it -> Pair.of(it.getRecipe(), (Object)it.getManager())).filter(pair -> this.targetingRule.shouldBeReplaced((IRecipe)pair.getFirst(), (IRecipeManager)pair.getSecond())).map(pair -> this.execute((IRecipeManager)pair.getSecond(), (IRecipe)pair.getFirst(), this.replacementRules)).filter(Optional::isPresent).map(Optional::get).forEach(CraftTweakerAPI::apply);
        CraftTweakerAPI.logInfo("Batch replacement completed", new Object[0]);
    }

    @Override
    public String describe() {
        return String.format("Batching replacement for %s according to replacement rules %s%s%s", this.stringifyTargets(), this.stringifyReplacementRules(), this.stringifyExclusionsIfPresent(), this.stringifySuppressWarnings());
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.replacementRules.isEmpty()) {
            logger.error("Invalid replacer action: no rules available");
            return false;
        }
        return true;
    }

    private String stringifyTargets() {
        return this.targetingRule.describe();
    }

    private String stringifyReplacementRules() {
        return this.replacementRules.stream().map(IReplacementRule::describe).collect(Collectors.joining(", ", "{", "}"));
    }

    private String stringifyExclusionsIfPresent() {
        if (this.defaultExclusions.isEmpty()) {
            return "";
        }
        return ", while also automatically excluding {" + this.stringifyDefaultExclusionsIfPresent() + "} due to mod requests";
    }

    private String stringifyDefaultExclusionsIfPresent() {
        return this.defaultExclusions.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
    }

    private String stringifySuppressWarnings() {
        return this.suppressWarnings ? " (Warnings are suppressed for this batch replacement)" : "";
    }

    private <T extends IInventory, U extends IRecipe<T>> Optional<ActionReplaceRecipe> execute(IRecipeManager manager, U recipe, List<IReplacementRule> rules) {
        try {
            IRecipeHandler<U> handler = CraftTweakerRegistry.getHandlerFor(recipe);
            Optional newRecipeMaybe = handler.replaceIngredients(manager, recipe, rules);
            if (newRecipeMaybe.isPresent()) {
                return Optional.of(new ActionReplaceRecipe(manager, this.generatorFunction, recipe, name -> (IRecipe)((Function)newRecipeMaybe.get()).apply(name)));
            }
        }
        catch (IRecipeHandler.ReplacementNotSupportedException e) {
            if (!this.suppressWarnings) {
                CraftTweakerAPI.logWarning("Unable to replace ingredients in recipe %s: %s", recipe.func_199560_c(), e.getMessage());
            }
        }
        catch (Throwable t) {
            CraftTweakerAPI.logThrowing("An error has occurred while trying to replace ingredients in recipe %s", t, recipe.func_199560_c());
        }
        return Optional.empty();
    }
}

