/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public final class SpecificRecipesTargetingRule
implements ITargetingRule {
    private final Collection<? extends IRecipe<?>> recipes;

    private SpecificRecipesTargetingRule(Collection<? extends IRecipe<?>> recipes) {
        this.recipes = Collections.unmodifiableCollection(recipes);
    }

    public static SpecificRecipesTargetingRule of(Collection<? extends IRecipe<?>> recipes) {
        if (recipes.isEmpty()) {
            throw new IllegalArgumentException("Unable to create a specific recipes targeting rule without any targets");
        }
        return new SpecificRecipesTargetingRule(recipes);
    }

    public static SpecificRecipesTargetingRule of(WrapperRecipe ... recipes) {
        return SpecificRecipesTargetingRule.of(Arrays.stream(recipes).map(WrapperRecipe::getRecipe).collect(Collectors.toSet()));
    }

    @Override
    public boolean shouldBeReplaced(IRecipe<?> recipe, IRecipeManager manager) {
        return this.recipes.contains(recipe);
    }

    @Override
    public String describe() {
        return this.recipes.stream().map(IRecipe::func_199560_c).map(ResourceLocation::toString).collect(Collectors.joining(", ", "recipes {", "}"));
    }
}

