/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.wrappers;

import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.recipes.CTRecipeShapeless;
import com.blamejared.crafttweaker.impl.recipes.Replacer;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/recipe/WrapperRecipe")
@ZenCodeType.Name(value="crafttweaker.api.recipes.WrapperRecipe")
public class WrapperRecipe
implements CommandStringDisplayable {
    private final IRecipe<?> recipe;

    public WrapperRecipe(@Nonnull IRecipe<?> recipe) {
        this.recipe = Objects.requireNonNull(recipe);
    }

    @ZenCodeType.Getter(value="id")
    public ResourceLocation getId() {
        return this.getRecipe().func_199560_c();
    }

    @ZenCodeType.Getter(value="group")
    public String getGroup() {
        return this.getRecipe().func_193358_e();
    }

    @ZenCodeType.Getter(value="output")
    public IItemStack getOutput() {
        return new MCItemStack(this.getRecipe().func_77571_b());
    }

    @ZenCodeType.Getter(value="dynamic")
    public boolean isDynamic() {
        return this.getRecipe().func_192399_d();
    }

    @ZenCodeType.Method
    public boolean canFit(int width, int height) {
        return this.getRecipe().func_194133_a(width, height);
    }

    @ZenCodeType.Getter(value="icon")
    public IItemStack getIcon() {
        return new MCItemStackMutable(this.getRecipe().func_222128_h());
    }

    @ZenCodeType.Getter(value="ingredients")
    public List<IIngredient> getIngredients() {
        return this.getRecipe().func_192400_c().stream().map(IIngredient::fromIngredient).collect(Collectors.toList());
    }

    @ZenCodeType.Getter(value="recipeManager")
    public IRecipeManager getManager() {
        return RecipeTypeBracketHandler.getOrDefault(this.recipe.func_222127_g());
    }

    public IRecipe<?> getRecipe() {
        return this.recipe;
    }

    @ZenCodeType.Getter(value="isShapedCraftingRecipe")
    public boolean isShapedCraftingRecipe() {
        return this.recipe instanceof IShapedRecipe;
    }

    @ZenCodeType.Getter(value="isShapelessCraftingRecipe")
    public boolean isShapelessCraftingRecipe() {
        return this.recipe instanceof ShapelessRecipe || this.recipe instanceof CTRecipeShapeless;
    }

    @Override
    @ZenCodeType.Getter(value="commandString")
    public String getCommandString() {
        return this.dump(CraftTweakerRegistry.getHandlerFor(this.recipe), this.recipe);
    }

    @ZenCodeType.Method
    public void replace(IIngredient from, IIngredient to) {
        Replacer.forRecipes(this).replaceFully(from, to).execute();
    }

    private <T extends IRecipe<?>> String dump(IRecipeHandler<T> handler, T recipe) {
        return handler.dumpToCommandString(this.getManager(), recipe);
    }
}

