/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.util.text;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.util.text.MCStyle;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.util.text.MCTextComponent")
@Document(value="vanilla/api/util/text/MCTextComponent")
@ZenWrapper(wrappedClass="net.minecraft.util.text.ITextComponent", conversionMethodFormat="%s.getInternal()", displayStringFormat="%s.toString()")
public class MCTextComponent {
    private final ITextComponent internal;

    public MCTextComponent(ITextComponent internal) {
        this.internal = internal;
    }

    public MCStyle getStyle() {
        return new MCStyle(this.getInternal().func_150256_b());
    }

    @ZenCodeType.Method
    public MCTextComponent setStyle(MCStyle style) {
        IFormattableTextComponent newInternal = this.getInternal().func_230532_e_();
        newInternal.func_230530_a_(newInternal.func_150256_b().func_240717_a_(style.getInternal()));
        return new MCTextComponent((ITextComponent)newInternal);
    }

    @ZenCodeType.Method
    public static MCTextComponent createStringTextComponent(String text) {
        return new MCTextComponent((ITextComponent)new StringTextComponent(text));
    }

    @ZenCodeType.Method
    public static MCTextComponent createTranslationTextComponent(String translationKey) {
        return new MCTextComponent((ITextComponent)new TranslationTextComponent(translationKey));
    }

    @ZenCodeType.Method
    public static MCTextComponent createTranslationTextComponent(String translationKey, Object ... args) {
        return new MCTextComponent((ITextComponent)new TranslationTextComponent(translationKey, args));
    }

    @ZenCodeType.Method
    public String getUnformattedComponentText() {
        return this.getInternal().func_150261_e();
    }

    @ZenCodeType.Getter(value="unformattedComponentText")
    public String getUnformattedComponentTextGetter() {
        return this.getUnformattedComponentText();
    }

    @ZenCodeType.Method
    public String getString() {
        return this.getInternal().getString();
    }

    @ZenCodeType.Caster
    public String asString() {
        return this.getString();
    }

    @ZenCodeType.Method
    public String getStringTruncated(int maxLen) {
        return this.getInternal().func_212636_a(maxLen);
    }

    @ZenCodeType.Getter(value="siblings")
    public List<MCTextComponent> getSiblings() {
        return this.getInternal().func_150253_a().stream().map(MCTextComponent::new).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    public MCTextComponent appendSibling(MCTextComponent component) {
        IFormattableTextComponent newInternal = this.getInternal().func_230532_e_();
        newInternal.func_150253_a().add(component.getInternal());
        return new MCTextComponent((ITextComponent)newInternal);
    }

    @ZenCodeType.Method
    public MCTextComponent copyRaw() {
        return new MCTextComponent((ITextComponent)this.getInternal().func_230531_f_());
    }

    @ZenCodeType.Method
    public MCTextComponent deepCopy() {
        return new MCTextComponent((ITextComponent)this.getInternal().func_230532_e_());
    }

    @ZenCodeType.Method
    public MCTextComponent appendText(String text) {
        IFormattableTextComponent newInternal = this.getInternal().func_230532_e_();
        newInternal.func_150253_a().add(new StringTextComponent(text));
        return new MCTextComponent((ITextComponent)newInternal);
    }

    @ZenCodeType.Getter(value="formattedText")
    public String getFormattedText() {
        return this.getInternal().getString();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CAT)
    public MCTextComponent opAppend(MCTextComponent component) {
        return this.appendSibling(component);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public MCTextComponent opAdd(MCTextComponent component) {
        return this.appendSibling(component);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SHL)
    public MCTextComponent opShLeft(MCTextComponent component) {
        return this.appendSibling(component);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CAT)
    public MCTextComponent opCat(String text) {
        return this.appendText(text);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public MCTextComponent opAdd(String text) {
        return this.appendText(text);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SHL)
    public MCTextComponent opLShift(String text) {
        return this.appendText(text);
    }

    public ITextComponent getInternal() {
        return this.internal;
    }
}

