/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.block.material;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/material/MCMaterial")
@NativeTypeRegistration(value=Material.class, zenCodeName="crafttweaker.api.block.material.MCMaterial")
public class ExpandMaterial {
    private static final BiMap<String, Material> hardcodedMaterials = HashBiMap.create();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="opaque")
    public static boolean isOpaque(Material internal) {
        return internal.func_76218_k();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="color")
    public static MaterialColor getColor(Material internal) {
        return internal.func_151565_r();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="solid")
    public static boolean isSolid(Material internal) {
        return internal.func_76220_a();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="flammable")
    public static boolean isFlammable(Material internal) {
        return internal.func_76217_h();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="liquid")
    public static boolean isLiquid(Material internal) {
        return internal.func_76224_d();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="replaceable")
    public static boolean isReplaceable(Material internal) {
        return internal.func_76222_j();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocksMovement")
    public static boolean blocksMovement(Material internal) {
        return internal.func_76230_c();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="pushReaction")
    public static PushReaction getPushReaction(Material internal) {
        return internal.func_186274_m();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Material internal) {
        BiMap inverse = hardcodedMaterials.inverse();
        String name = (String)inverse.getOrDefault((Object)internal, (Object)"UNKNOWN");
        return "<blockmaterial:" + name + ">";
    }

    public static Material tryGet(String tokens) {
        return (Material)hardcodedMaterials.get((Object)tokens.toUpperCase());
    }

    static {
        hardcodedMaterials.put((Object)"AIR", (Object)Material.field_151579_a);
        hardcodedMaterials.put((Object)"STRUCTURE_VOID", (Object)Material.field_189963_J);
        hardcodedMaterials.put((Object)"PORTAL", (Object)Material.field_151567_E);
        hardcodedMaterials.put((Object)"CARPET", (Object)Material.field_151593_r);
        hardcodedMaterials.put((Object)"PLANTS", (Object)Material.field_151585_k);
        hardcodedMaterials.put((Object)"OCEAN_PLANT", (Object)Material.field_203243_f);
        hardcodedMaterials.put((Object)"TALL_PLANTS", (Object)Material.field_151582_l);
        hardcodedMaterials.put((Object)"SEA_GRASS", (Object)Material.field_204868_h);
        hardcodedMaterials.put((Object)"WATER", (Object)Material.field_151586_h);
        hardcodedMaterials.put((Object)"BUBBLE_COLUMN", (Object)Material.field_203244_i);
        hardcodedMaterials.put((Object)"LAVA", (Object)Material.field_151587_i);
        hardcodedMaterials.put((Object)"SNOW", (Object)Material.field_151597_y);
        hardcodedMaterials.put((Object)"FIRE", (Object)Material.field_151581_o);
        hardcodedMaterials.put((Object)"MISCELLANEOUS", (Object)Material.field_151594_q);
        hardcodedMaterials.put((Object)"WEB", (Object)Material.field_151569_G);
        hardcodedMaterials.put((Object)"REDSTONE_LIGHT", (Object)Material.field_151591_t);
        hardcodedMaterials.put((Object)"CLAY", (Object)Material.field_151571_B);
        hardcodedMaterials.put((Object)"EARTH", (Object)Material.field_151578_c);
        hardcodedMaterials.put((Object)"ORGANIC", (Object)Material.field_151577_b);
        hardcodedMaterials.put((Object)"PACKED_ICE", (Object)Material.field_151598_x);
        hardcodedMaterials.put((Object)"SAND", (Object)Material.field_151595_p);
        hardcodedMaterials.put((Object)"SPONGE", (Object)Material.field_151583_m);
        hardcodedMaterials.put((Object)"SHULKER", (Object)Material.field_215711_w);
        hardcodedMaterials.put((Object)"WOOD", (Object)Material.field_151575_d);
        hardcodedMaterials.put((Object)"BAMBOO_SAPLING", (Object)Material.field_215712_y);
        hardcodedMaterials.put((Object)"BAMBOO", (Object)Material.field_215713_z);
        hardcodedMaterials.put((Object)"WOOL", (Object)Material.field_151580_n);
        hardcodedMaterials.put((Object)"TNT", (Object)Material.field_151590_u);
        hardcodedMaterials.put((Object)"LEAVES", (Object)Material.field_151584_j);
        hardcodedMaterials.put((Object)"GLASS", (Object)Material.field_151592_s);
        hardcodedMaterials.put((Object)"ICE", (Object)Material.field_151588_w);
        hardcodedMaterials.put((Object)"CACTUS", (Object)Material.field_151570_A);
        hardcodedMaterials.put((Object)"ROCK", (Object)Material.field_151576_e);
        hardcodedMaterials.put((Object)"IRON", (Object)Material.field_151573_f);
        hardcodedMaterials.put((Object)"SNOW_BLOCK", (Object)Material.field_151596_z);
        hardcodedMaterials.put((Object)"ANVIL", (Object)Material.field_151574_g);
        hardcodedMaterials.put((Object)"BARRIER", (Object)Material.field_175972_I);
        hardcodedMaterials.put((Object)"PISTON", (Object)Material.field_76233_E);
        hardcodedMaterials.put((Object)"CORAL", (Object)Material.field_151589_v);
        hardcodedMaterials.put((Object)"GOURD", (Object)Material.field_151572_C);
        hardcodedMaterials.put((Object)"DRAGON_EGG", (Object)Material.field_151566_D);
        hardcodedMaterials.put((Object)"CAKE", (Object)Material.field_151568_F);
    }
}

