/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.blocks;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.actions.blocks.ActionSetBlockProperty;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerBlock;
import com.blamejared.crafttweaker.impl_native.block.material.ExpandMaterial;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/MCBlock")
@NativeTypeRegistration(value=Block.class, zenCodeName="crafttweaker.api.blocks.MCBlock")
public class ExpandBlock {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    public static ResourceLocation getRegistryName(Block internal) {
        return internal.getRegistryName();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="defaultState")
    public static BlockState getDefaultState(Block internal) {
        return internal.func_176223_P();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="lootTable")
    public static String getLootTable(Block internal) {
        return internal.func_220068_i().toString();
    }

    @ZenCodeType.Method
    public static boolean canSpawnInBlock(Block internal) {
        return internal.func_181623_g();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="translationKey")
    public static String getTranslationKey(Block internal) {
        return internal.func_149739_a();
    }

    @ZenCodeType.Caster
    public static String asString(Block internal) {
        return internal.toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Block internal) {
        return "<block:" + internal.getRegistryName() + ">";
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="validStates")
    public static List<BlockState> getValidStates(Block internal) {
        return internal.func_176194_O().func_177619_a();
    }

    @ZenCodeType.Method
    public static boolean isInTag(Block internal, MCTag<Block> tag) {
        return internal.func_203417_a(tag.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public static boolean matchesBlock(Block internal, Block other) {
        return internal.func_235332_a_(other);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tags")
    public static List<MCTag<Block>> getTags(Block internal) {
        return internal.getTags().stream().map(TagManagerBlock.INSTANCE::getTag).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="slipperiness")
    public static float getSlipperiness(Block internal) {
        return internal.func_208618_m();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="slipperiness")
    public static void setSlipperiness(Block internal, float slipperiness) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Slipperiness", Float.valueOf(slipperiness), Float.valueOf(internal.field_149765_K), value -> {
            internal.field_149765_K = value.floatValue();
        }));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="speedFactor")
    public static float getSpeedFactor(Block internal) {
        return internal.func_226891_m_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="speedFactor")
    public static void setSpeedFactor(Block internal, float speedFactor) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Speed Factor", Float.valueOf(speedFactor), Float.valueOf(internal.field_226886_f_), value -> {
            internal.field_226886_f_ = value.floatValue();
        }));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="jumpFactor")
    public static float getJumpFactor(Block internal) {
        return internal.func_226892_n_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="jumpFactor")
    public static void setJumpFactor(Block internal, float jumpFactor) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Jump Factor", Float.valueOf(jumpFactor), Float.valueOf(internal.field_226887_g_), value -> {
            internal.field_226887_g_ = value.floatValue();
        }));
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster
    public static Item asItem(Block internal) {
        return internal.func_199767_j();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="variableOpacity")
    public static boolean isVariableOpacity(Block internal) {
        return internal.func_208619_r();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canCollide")
    public static boolean canCollide(Block internal) {
        return internal.field_235688_at_;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="canCollide")
    public static void setCanCollide(Block internal, boolean canCollide) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Boolean>(internal, "Can Collide", canCollide, internal.field_235688_at_, value -> {
            internal.field_235688_at_ = value;
        }));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blastResistance")
    public static float getBlastResistance(Block internal) {
        return internal.field_235689_au_;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="blastResistance")
    public static void setBlastResistance(Block internal, float resistance) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Blast Resistance", Float.valueOf(resistance), Float.valueOf(internal.field_235689_au_), value -> {
            internal.field_235689_au_ = value.floatValue();
        }));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="material")
    public static Material getMaterial(Block internal) {
        return internal.field_149764_J;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="material")
    public static void setMaterial(Block internal, Material material) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Material>(internal, "Material", material, internal.field_149764_J, value -> {
            internal.field_149764_J = material;
        }, ExpandMaterial::getCommandString));
    }
}

