/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.TypeMatcher;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;

public interface TypeID {
    public static final TypeID[] NONE = new TypeID[0];

    public static Map<TypeParameter, TypeID> getMapping(TypeParameter[] parameters, TypeID[] arguments) {
        HashMap<TypeParameter, TypeID> typeArguments = new HashMap<TypeParameter, TypeID>();
        for (int i = 0; i < parameters.length; ++i) {
            typeArguments.put(parameters[i], arguments[i]);
        }
        return typeArguments;
    }

    public static Map<TypeParameter, TypeID> getSelfMapping(GlobalTypeRegistry registry, TypeParameter[] parameters) {
        HashMap<TypeParameter, TypeID> typeArguments = new HashMap<TypeParameter, TypeID>();
        for (TypeParameter parameter : parameters) {
            typeArguments.put(parameter, registry.getGeneric(parameter));
        }
        return typeArguments;
    }

    default public TypeID getSuperType(GlobalTypeRegistry registry) {
        return null;
    }

    public TypeID instance(GenericMapper var1);

    public TypeID getNormalized();

    public boolean hasDefaultValue();

    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] var1);

    default public Expression getDefaultValue() {
        return null;
    }

    default public Map<TypeParameter, TypeID> inferTypeParameters(LocalMemberCache cache, TypeID targetType) {
        return TypeMatcher.match(cache, this, targetType);
    }

    public void extractTypeParameters(List<TypeParameter> var1);

    public <R> R accept(TypeVisitor<R> var1);

    public <C, R, E extends Exception> R accept(C var1, TypeVisitorWithContext<C, R, E> var2) throws E;

    default public boolean isOptional() {
        return false;
    }

    default public boolean isGeneric() {
        return false;
    }

    public boolean isValueType();

    default public TypeID withoutOptional() {
        throw new UnsupportedOperationException("Not an optional type");
    }

    default public boolean isVariant() {
        return false;
    }

    default public boolean isEnum() {
        return false;
    }

    default public boolean isDefinition(HighLevelDefinition definition) {
        return false;
    }

    default public boolean canCastImplicitTo(TypeID other) {
        return false;
    }

    default public boolean canCastExplicitTo(TypeID other) {
        return false;
    }

    default public boolean canCastImplicitFrom(TypeID other) {
        return false;
    }

    default public boolean canCastExplicitFrom(TypeID other) {
        return false;
    }

    default public Expression castImplicitTo(CodePosition position, Expression value, TypeID toType) {
        return null;
    }

    default public Expression castExplicitTo(CodePosition position, Expression value, TypeID toOther) {
        return null;
    }

    default public Expression castImplicitFrom(CodePosition position, Expression value) {
        return null;
    }

    default public Expression castExplicitFrom(CodePosition position, Expression value) {
        return null;
    }
}

