/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.type.IParsedType;

public class ParsedCallArguments {
    public static final ParsedCallArguments NONE = new ParsedCallArguments(null, Collections.emptyList());
    public final List<ParsedExpression> arguments;
    private final List<IParsedType> typeArguments;

    public ParsedCallArguments(List<IParsedType> typeArguments, List<ParsedExpression> arguments) {
        this.typeArguments = typeArguments;
        this.arguments = arguments;
    }

    public static ParsedCallArguments parse(ZSTokenParser tokens) throws ParseException {
        List<IParsedType> typeArguments = IParsedType.parseTypeArgumentsForCall(tokens);
        tokens.required(ZSTokenType.T_BROPEN, "( expected");
        ArrayList<ParsedExpression> arguments = new ArrayList<ParsedExpression>();
        try {
            if (tokens.optional(ZSTokenType.T_BRCLOSE) == null) {
                do {
                    arguments.add(ParsedExpression.parse(tokens));
                } while (tokens.optional(ZSTokenType.T_COMMA) != null);
                tokens.required(ZSTokenType.T_BRCLOSE, ") expected");
            }
        }
        catch (ParseException ex) {
            tokens.logError(ex);
            tokens.recoverUntilOnToken(ZSTokenType.T_BRCLOSE);
        }
        return new ParsedCallArguments(typeArguments, arguments);
    }

    public static ParsedCallArguments parseForAnnotation(ZSTokenParser tokens) throws ParseException {
        List<IParsedType> typeArguments = IParsedType.parseTypeArgumentsForCall(tokens);
        ArrayList<ParsedExpression> arguments = new ArrayList<ParsedExpression>();
        if (tokens.isNext(ZSTokenType.T_BROPEN)) {
            tokens.required(ZSTokenType.T_BROPEN, "( expected");
            try {
                if (tokens.optional(ZSTokenType.T_BRCLOSE) == null) {
                    do {
                        arguments.add(ParsedExpression.parse(tokens));
                    } while (tokens.optional(ZSTokenType.T_COMMA) != null);
                    tokens.required(ZSTokenType.T_BRCLOSE, ") expected");
                }
            }
            catch (ParseException ex) {
                tokens.logError(ex);
                tokens.recoverUntilOnToken(ZSTokenType.T_BRCLOSE);
            }
        }
        return new ParsedCallArguments(typeArguments, arguments);
    }

    public CallArguments compileCall(CodePosition position, ExpressionScope scope, TypeID[] genericParameters, TypeMemberGroup member) throws CompileException {
        List<FunctionHeader> possibleHeaders = member.getMethodMembers().stream().map(method -> ((FunctionalMemberRef)method.member).getHeader()).collect(Collectors.toList());
        return this.compileCall(position, scope, genericParameters, possibleHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public CallArguments compileCall(CodePosition position, ExpressionScope scope, TypeID[] typeArguments, List<FunctionHeader> candidateFunctions) throws CompileException {
        void var9_22;
        Iterator<Object> iterator;
        void var9_19;
        int i;
        if (this.typeArguments != null) {
            typeArguments = new TypeID[this.typeArguments.size()];
            for (int i2 = 0; i2 < this.typeArguments.size(); ++i2) {
                typeArguments[i2] = this.typeArguments.get(i2).compile(scope);
            }
        }
        List<Object> candidates = new ArrayList<FunctionHeader>();
        for (FunctionHeader header : candidateFunctions) {
            if (!this.isCompatibleWith(scope, header, typeArguments)) continue;
            candidates.add(header);
        }
        if (candidates.isEmpty()) {
            StringBuilder explanation = new StringBuilder("No compatible methods found");
            CallArguments arguments = this.compileCallNaive(position, scope);
            if (!candidateFunctions.isEmpty()) {
                explanation.append(":\n");
                for (FunctionHeader functionHeader : candidateFunctions) {
                    explanation.append(functionHeader.explainWhyIncompatible(scope, arguments)).append("\n");
                }
            } else {
                explanation.append("!");
            }
            throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, explanation.toString());
        }
        ExpressionScope innerScope = scope;
        if (candidates.size() == 1) {
            innerScope = scope.forCall((FunctionHeader)candidates.get(0));
        } else {
            int givenTypeArguments = typeArguments == null ? 0 : typeArguments.length;
            if ((candidates = candidates.stream().filter(candidate -> candidate.getNumberOfTypeParameters() == givenTypeArguments).collect(Collectors.toList())).isEmpty()) {
                throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, "Could not determine call type parameters");
            }
        }
        List[] predictedTypes = new List[this.arguments.size()];
        for (int i3 = 0; i3 < predictedTypes.length; ++i3) {
            predictedTypes[i3] = new ArrayList();
        }
        for (FunctionHeader functionHeader : candidates) {
            boolean variadic;
            block19: {
                variadic = functionHeader.isVariadic();
                if (typeArguments != null && typeArguments.length > 0 && functionHeader.typeParameters.length == typeArguments.length) {
                    HashMap<TypeParameter, TypeID> types = new HashMap<TypeParameter, TypeID>();
                    for (i = 0; i < functionHeader.typeParameters.length; ++i) {
                        if (functionHeader.typeParameters[i].matches(scope.getMemberCache(), typeArguments[i])) {
                            types.put(functionHeader.typeParameters[i], typeArguments[i]);
                            continue;
                        }
                        break block19;
                    }
                    FunctionHeader functionHeader2 = functionHeader.withGenericArguments(new GenericMapper(position, scope.getTypeRegistry(), types));
                }
            }
            for (int i4 = 0; i4 < this.arguments.size(); ++i4) {
                void var9_15;
                TypeID parameterType = var9_15.getParameterType(variadic, i4);
                if (predictedTypes[i4].contains(parameterType)) continue;
                predictedTypes[i4].add(parameterType);
            }
        }
        Expression[] cArguments = new Expression[this.arguments.size()];
        boolean bl = false;
        while (var9_19 < cArguments.length) {
            IPartialExpression cArgument = this.arguments.get((int)var9_19).compile(innerScope.withHints(predictedTypes[var9_19]));
            cArguments[var9_19] = cArgument.eval();
            ++var9_19;
        }
        TypeID[] typeIDArray = typeArguments;
        if ((typeIDArray == null || typeIDArray.length == 0) && (iterator = candidates.iterator()).hasNext()) {
            FunctionHeader candidate3 = (FunctionHeader)iterator.next();
            TypeID[] typeIDArray2 = new TypeID[candidate3.typeParameters.length];
            for (i = 0; i < typeIDArray2.length; ++i) {
                typeIDArray2[i] = innerScope.genericInferenceMap.get(candidate3.typeParameters[i]) == null ? new InvalidTypeID(position, CompileExceptionCode.TYPE_ARGUMENTS_NOT_INFERRABLE, "Could not infer type parameter " + candidate3.typeParameters[i].name) : innerScope.genericInferenceMap.get(candidate3.typeParameters[i]);
            }
        }
        return new CallArguments((TypeID[])var9_22, cArguments);
    }

    public CallArguments compileCall(CodePosition position, ExpressionScope scope, TypeID[] typeArguments, FunctionHeader function) throws CompileException {
        ExpressionScope innerScope = scope.forCall(function);
        List[] predictedTypes = new List[this.arguments.size()];
        for (int i = 0; i < predictedTypes.length; ++i) {
            predictedTypes[i] = new ArrayList();
            predictedTypes[i].add(function.parameters[i].type);
        }
        Expression[] cArguments = new Expression[this.arguments.size()];
        for (int i = 0; i < cArguments.length; ++i) {
            IPartialExpression cArgument = this.arguments.get(i).compile(innerScope.withHints(predictedTypes[i]));
            cArguments[i] = cArgument.eval();
        }
        TypeID[] typeArguments2 = typeArguments;
        if (typeArguments2 == null) {
            typeArguments2 = new TypeID[function.typeParameters.length];
            for (int i = 0; i < typeArguments2.length; ++i) {
                if (innerScope.genericInferenceMap.get(function.typeParameters[i]) == null) {
                    throw new CompileException(position, CompileExceptionCode.TYPE_ARGUMENTS_NOT_INFERRABLE, "Could not infer type parameter " + function.typeParameters[i].name);
                }
                typeArguments2[i] = innerScope.genericInferenceMap.get(function.typeParameters[i]);
            }
        }
        return new CallArguments(typeArguments2, cArguments);
    }

    private CallArguments compileCallNaive(CodePosition position, ExpressionScope scope) throws CompileException {
        Expression[] cArguments = new Expression[this.arguments.size()];
        for (int i = 0; i < cArguments.length; ++i) {
            IPartialExpression cArgument = this.arguments.get(i).compile(scope);
            cArguments[i] = cArgument.eval();
        }
        return new CallArguments(TypeID.NONE, cArguments);
    }

    private boolean isCompatibleWith(BaseScope scope, FunctionHeader header, TypeID[] typeArguments) {
        if (!header.accepts(this.arguments.size())) {
            return false;
        }
        boolean variadic = header.isVariadic();
        for (int i = 0; i < this.arguments.size(); ++i) {
            FunctionParameter parameter = header.getParameter(variadic, i);
            if (typeArguments == null && parameter.type.hasInferenceBlockingTypeParameters(header.typeParameters)) {
                return false;
            }
            if (this.arguments.get(i).isCompatibleWith(scope, header.getParameterType(variadic, i).getNormalized())) continue;
            return false;
        }
        return true;
    }
}

