/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.ccrp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.flytre.ccrp.config.Config;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class ConfigHandler {
    private final Gson GSON;
    public Config CONFIG;
    private Config DEFAULT = Config.defaultConfig();

    public ConfigHandler() {
        this.GSON = new GsonBuilder().setPrettyPrinting().create();
        this.handleConfig();
    }

    public void handleConfig() {
        Path location = FabricLoader.getInstance().getConfigDir();
        File config = location.toFile();
        File configFile = null;
        for (File file : config.listFiles()) {
            if (!file.getName().equals("crazy_creepers.json")) continue;
            configFile = file;
            break;
        }
        if (configFile == null) {
            Path path = Paths.get(location.toString(), "crazy_creepers.json");
            try {
                FileWriter writer = new FileWriter(path.toFile());
                JsonObject jsonObject = Config.defaultConfig().toJSON(this.GSON);
                this.GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
                this.CONFIG = this.DEFAULT;
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (FileReader reader = new FileReader(configFile);){
                JsonObject object = (JsonObject)this.GSON.fromJson((Reader)reader, JsonObject.class);
                HashMap hashMap = new HashMap();
                for (Map.Entry string : object.entrySet()) {
                    class_1299<?> type = this.getEntityType((String)string.getKey());
                    Config.CreeperConfig cc = (Config.CreeperConfig)this.GSON.fromJson((JsonElement)string.getValue(), Config.CreeperConfig.class);
                    hashMap.put(type, cc);
                    this.CONFIG = new Config(hashMap);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class_1299<?> getEntityType(String string) {
        for (class_1299 type : class_2378.field_11145) {
            class_2960 id = class_2378.field_11145.method_10221((Object)type);
            if (!id.method_12836().equals("ccrp") || !id.method_12832().equals(string)) continue;
            return type;
        }
        return null;
    }
}

