/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.crewmatesmod.entities;

import com.coldspell.crewmatesmod.entities.CrewmateAttackGoal;
import com.coldspell.crewmatesmod.entities.ImposterAttackGoal;
import com.coldspell.crewmatesmod.util.ConfigurationHandler;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class CrewmateEntity
extends CreatureEntity {
    public static boolean isImposter;
    private static final DataParameter<Integer> CREW_TYPE;
    private static final DataParameter<Integer> NAME_TYPE;
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_ID;
    public static final Map<Integer, ITextComponent> NAME_BY_ID;

    public CrewmateEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        if (isImposter) {
            return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 2.0);
        }
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233825_h_, 6.0);
    }

    protected void func_184651_r() {
        this.func_174805_g(true);
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (isImposter) {
            this.applyImposterAI();
        } else {
            this.applyCrewmateAI();
        }
    }

    protected void applyImposterAI() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ImposterAttackGoal(this, 1.1, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.2f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.1));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CrewmateEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
    }

    protected void applyCrewmateAI() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CrewmateAttackGoal(this, 1.1, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.1));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{CrewmateEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187946_ht, 0.15f, 1.0f);
    }

    public ResourceLocation getCrewTypeName() {
        return TEXTURE_BY_ID.getOrDefault(this.getCrewType(), TEXTURE_BY_ID.get(0));
    }

    public int getCrewType() {
        return (Integer)this.field_70180_af.func_187225_a(CREW_TYPE);
    }

    public void setCrewType(int type) {
        if (type < 0 || type >= 11) {
            type = this.field_70146_Z.nextInt(10);
        }
        this.field_70180_af.func_187227_b(CREW_TYPE, (Object)type);
    }

    public ITextComponent getCustomTypeName() {
        return NAME_BY_ID.getOrDefault(this.getNameType(), NAME_BY_ID.get(0));
    }

    public int getNameType() {
        return (Integer)this.field_70180_af.func_187225_a(NAME_TYPE);
    }

    public void setNameType(int type) {
        if (type < 0 || type >= 102) {
            type = this.field_70146_Z.nextInt(102);
        }
        this.field_70180_af.func_187227_b(NAME_TYPE, (Object)type);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCrewType(compound.func_74762_e("CrewType"));
        this.setNameType(compound.func_74762_e("NameType"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("CrewType", this.getCrewType());
        compound.func_74768_a("NameType", this.getNameType());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CREW_TYPE, (Object)1);
        this.field_70180_af.func_187214_a(NAME_TYPE, (Object)1);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setCrewType(this.field_70146_Z.nextInt(11));
        this.setNameType(this.field_70146_Z.nextInt(102));
        this.func_94059_bO();
        this.func_200203_b(this.getCustomTypeName());
        if (((Boolean)ConfigurationHandler.SPAWN.imposter.get()).booleanValue()) {
            Random random = new Random();
            int imposterChance = random.nextInt(5);
            isImposter = imposterChance == 0;
        }
        return spawnDataIn;
    }

    static {
        CREW_TYPE = EntityDataManager.func_187226_a(CrewmateEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        NAME_TYPE = EntityDataManager.func_187226_a(CrewmateEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        TEXTURE_BY_ID = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_213410_0_ -> {
            p_213410_0_.put(0, new ResourceLocation("crewmatesmod", "textures/entity/black.png"));
            p_213410_0_.put(1, new ResourceLocation("crewmatesmod", "textures/entity/blue.png"));
            p_213410_0_.put(2, new ResourceLocation("crewmatesmod", "textures/entity/green.png"));
            p_213410_0_.put(3, new ResourceLocation("crewmatesmod", "textures/entity/cyan.png"));
            p_213410_0_.put(4, new ResourceLocation("crewmatesmod", "textures/entity/orange.png"));
            p_213410_0_.put(5, new ResourceLocation("crewmatesmod", "textures/entity/pink.png"));
            p_213410_0_.put(6, new ResourceLocation("crewmatesmod", "textures/entity/purple.png"));
            p_213410_0_.put(7, new ResourceLocation("crewmatesmod", "textures/entity/red.png"));
            p_213410_0_.put(8, new ResourceLocation("crewmatesmod", "textures/entity/white.png"));
            p_213410_0_.put(9, new ResourceLocation("crewmatesmod", "textures/entity/yellow.png"));
            p_213410_0_.put(10, new ResourceLocation("crewmatesmod", "textures/entity/lime_green.png"));
        });
        NAME_BY_ID = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_213410_0_ -> {
            p_213410_0_.put(0, new TranslationTextComponent("Player"));
            p_213410_0_.put(1, new TranslationTextComponent("N00B"));
            p_213410_0_.put(2, new TranslationTextComponent("Ninja"));
            p_213410_0_.put(3, new TranslationTextComponent("Innocent"));
            p_213410_0_.put(4, new TranslationTextComponent("FARTS"));
            p_213410_0_.put(5, new TranslationTextComponent("Cold"));
            p_213410_0_.put(6, new TranslationTextComponent("Metric"));
            p_213410_0_.put(7, new TranslationTextComponent("Titan"));
            p_213410_0_.put(8, new TranslationTextComponent("Cookie"));
            p_213410_0_.put(9, new TranslationTextComponent("No One"));
            p_213410_0_.put(10, new TranslationTextComponent("Crewmate"));
            p_213410_0_.put(11, new TranslationTextComponent("Who"));
            p_213410_0_.put(12, new TranslationTextComponent("Trust Me"));
            p_213410_0_.put(13, new TranslationTextComponent("DontKillMe"));
            p_213410_0_.put(14, new TranslationTextComponent("Doodle"));
            p_213410_0_.put(15, new TranslationTextComponent("Poop"));
            p_213410_0_.put(16, new TranslationTextComponent("notathreat"));
            p_213410_0_.put(17, new TranslationTextComponent("Eleven"));
            p_213410_0_.put(18, new TranslationTextComponent("Imposter"));
            p_213410_0_.put(19, new TranslationTextComponent("Not Imposter"));
            p_213410_0_.put(20, new TranslationTextComponent("Wasnt Me"));
            p_213410_0_.put(21, new TranslationTextComponent("Sus"));
            p_213410_0_.put(22, new TranslationTextComponent("Your Boi"));
            p_213410_0_.put(23, new TranslationTextComponent("Salty"));
            p_213410_0_.put(24, new TranslationTextComponent("???"));
            p_213410_0_.put(25, new TranslationTextComponent("Dr Suspecty"));
            p_213410_0_.put(26, new TranslationTextComponent("pewds"));
            p_213410_0_.put(27, new TranslationTextComponent("TinyAstronaut"));
            p_213410_0_.put(28, new TranslationTextComponent("Ben Dover"));
            p_213410_0_.put(29, new TranslationTextComponent("The DOCTOR"));
            p_213410_0_.put(30, new TranslationTextComponent("The Other Guy"));
            p_213410_0_.put(31, new TranslationTextComponent("Potato Salad"));
            p_213410_0_.put(32, new TranslationTextComponent("7 of 9"));
            p_213410_0_.put(33, new TranslationTextComponent("Look Over There"));
            p_213410_0_.put(34, new TranslationTextComponent("Abe Lincoln"));
            p_213410_0_.put(35, new TranslationTextComponent("Overlord"));
            p_213410_0_.put(36, new TranslationTextComponent("Toast"));
            p_213410_0_.put(37, new TranslationTextComponent("Senpai"));
            p_213410_0_.put(38, new TranslationTextComponent("ObiWan"));
            p_213410_0_.put(39, new TranslationTextComponent("Nutella"));
            p_213410_0_.put(40, new TranslationTextComponent("Gizmo"));
            p_213410_0_.put(41, new TranslationTextComponent("Shoe"));
            p_213410_0_.put(42, new TranslationTextComponent("Player2"));
            p_213410_0_.put(43, new TranslationTextComponent("Waffles"));
            p_213410_0_.put(44, new TranslationTextComponent("banana"));
            p_213410_0_.put(45, new TranslationTextComponent("happy"));
            p_213410_0_.put(46, new TranslationTextComponent("Peaches"));
            p_213410_0_.put(47, new TranslationTextComponent("Hotty Hot"));
            p_213410_0_.put(48, new TranslationTextComponent("Zero"));
            p_213410_0_.put(49, new TranslationTextComponent("xXx"));
            p_213410_0_.put(50, new TranslationTextComponent("Baby Yoda"));
            p_213410_0_.put(51, new TranslationTextComponent("Meli"));
            p_213410_0_.put(52, new TranslationTextComponent("SirGogoatShirt"));
            p_213410_0_.put(53, new TranslationTextComponent("AngelPuzzle"));
            p_213410_0_.put(54, new TranslationTextComponent("Treedude"));
            p_213410_0_.put(55, new TranslationTextComponent("coleslaw"));
            p_213410_0_.put(56, new TranslationTextComponent("Winterbreeze"));
            p_213410_0_.put(57, new TranslationTextComponent("Coldspell"));
            p_213410_0_.put(58, new TranslationTextComponent("GarryTale"));
            p_213410_0_.put(59, new TranslationTextComponent("Ogo"));
            p_213410_0_.put(60, new TranslationTextComponent("The Dude"));
            p_213410_0_.put(61, new TranslationTextComponent("Your Mom"));
            p_213410_0_.put(62, new TranslationTextComponent("Red"));
            p_213410_0_.put(63, new TranslationTextComponent("Blue"));
            p_213410_0_.put(64, new TranslationTextComponent("Yellow"));
            p_213410_0_.put(65, new TranslationTextComponent("Green"));
            p_213410_0_.put(66, new TranslationTextComponent("Lime"));
            p_213410_0_.put(67, new TranslationTextComponent("Black"));
            p_213410_0_.put(68, new TranslationTextComponent("Brown"));
            p_213410_0_.put(69, new TranslationTextComponent("Cyan"));
            p_213410_0_.put(70, new TranslationTextComponent("Pink"));
            p_213410_0_.put(71, new TranslationTextComponent("Orange"));
            p_213410_0_.put(72, new TranslationTextComponent("Purple"));
            p_213410_0_.put(73, new TranslationTextComponent("White"));
            p_213410_0_.put(74, new TranslationTextComponent("Skip"));
            p_213410_0_.put(75, new TranslationTextComponent("Kroko25"));
            p_213410_0_.put(76, new TranslationTextComponent("Haxor"));
            p_213410_0_.put(77, new TranslationTextComponent("Lukas"));
            p_213410_0_.put(78, new TranslationTextComponent("Bob"));
            p_213410_0_.put(79, new TranslationTextComponent("Johnny"));
            p_213410_0_.put(80, new TranslationTextComponent("DUDE"));
            p_213410_0_.put(81, new TranslationTextComponent("Lee"));
            p_213410_0_.put(82, new TranslationTextComponent("Toast"));
            p_213410_0_.put(83, new TranslationTextComponent("Furry"));
            p_213410_0_.put(84, new TranslationTextComponent("Mom"));
            p_213410_0_.put(85, new TranslationTextComponent("Dad"));
            p_213410_0_.put(86, new TranslationTextComponent("Cheese"));
            p_213410_0_.put(87, new TranslationTextComponent("Bug"));
            p_213410_0_.put(88, new TranslationTextComponent("Doc"));
            p_213410_0_.put(89, new TranslationTextComponent("MrNiceGuy"));
            p_213410_0_.put(90, new TranslationTextComponent("Banana"));
            p_213410_0_.put(91, new TranslationTextComponent("I'm Poster"));
            p_213410_0_.put(92, new TranslationTextComponent("EA Games"));
            p_213410_0_.put(93, new TranslationTextComponent("OBeOneCanoli"));
            p_213410_0_.put(94, new TranslationTextComponent("Angelina Goalie"));
            p_213410_0_.put(95, new TranslationTextComponent("Neonx13"));
            p_213410_0_.put(96, new TranslationTextComponent("suffer"));
            p_213410_0_.put(97, new TranslationTextComponent("Aarav"));
            p_213410_0_.put(98, new TranslationTextComponent("Dottie"));
            p_213410_0_.put(99, new TranslationTextComponent("JiJi"));
            p_213410_0_.put(100, new TranslationTextComponent("MR CHEESE"));
            p_213410_0_.put(101, new TranslationTextComponent("Kirby"));
        });
    }
}

