/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import me.thonk.croptopia.CroptopiaForge;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public class BiomeLootCondition
implements LootItemCondition {
    private final Biome.BiomeCategory biomeCategory;

    private BiomeLootCondition(Biome.BiomeCategory category) {
        this.biomeCategory = category;
    }

    public LootItemConditionType m_7940_() {
        return CroptopiaForge.BIOME_CHECK;
    }

    public boolean test(LootContext lootContext) {
        if (this.biomeCategory == Biome.BiomeCategory.NONE) {
            return true;
        }
        Vec3 vec3d = (Vec3)lootContext.m_165124_(LootContextParams.f_81460_);
        if (vec3d != null) {
            Biome biome = lootContext.m_78952_().m_46857_(new BlockPos(vec3d));
            return biome.m_47567_() == this.biomeCategory;
        }
        return false;
    }

    public static Builder builder(Biome.BiomeCategory category) {
        return new Builder(category);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Biome.BiomeCategory biomeCategory;

        public Builder(Biome.BiomeCategory biome) {
            this.biomeCategory = biome;
        }

        public LootItemCondition m_6409_() {
            return new BiomeLootCondition(this.biomeCategory);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BiomeLootCondition> {
        public void serialize(JsonObject json, BiomeLootCondition object, JsonSerializationContext context) {
            json.addProperty("biome_category", object.biomeCategory.m_47645_());
        }

        public BiomeLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            Biome.BiomeCategory category = Biome.BiomeCategory.m_47643_((String)GsonHelper.m_13805_((JsonElement)json, (String)"biome_category"));
            return new BiomeLootCondition(category);
        }
    }
}

