/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia.blocks;

import java.util.Random;
import me.thonk.croptopia.blocks.CroptopiaCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class LeafCropBlock
extends CroptopiaCropBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;

    public LeafCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState p_52297_, BlockGetter p_52298_, BlockPos p_52299_, CollisionContext p_52300_) {
        return Shapes.m_83144_();
    }

    public ItemStack m_7397_(BlockGetter p_52254_, BlockPos p_52255_, BlockState p_52256_) {
        return new ItemStack((ItemLike)this);
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int distance = LeafCropBlock.getDistance(neighborState) + 1;
        if (distance != 1 || (Integer)state.m_61143_((Property)DISTANCE) != distance) {
            world.m_6219_().m_5945_(pos, (Object)this, 1);
        }
        return state;
    }

    public int m_7419_() {
        return 3;
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, DISTANCE});
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        int i;
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt(100) % 20 == 0 ? 1 : 0) != 0)) {
            world.m_7731_(pos, this.m_52289_(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if ((Integer)state.m_61143_((Property)DISTANCE) == 7) {
            LeafCropBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            world.m_7471_(pos, false);
        }
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        worldIn.m_7731_(pos, LeafCropBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor world, BlockPos pos) {
        int distance = 7;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            distance = Math.min(distance, LeafCropBlock.getDistance(world.m_8055_((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private static int getDistance(BlockState state) {
        if (state.m_60620_((Tag)BlockTags.f_13106_)) {
            return 0;
        }
        return state.m_60734_() instanceof LeafCropBlock || state.m_60734_() instanceof LeavesBlock ? (Integer)state.m_61143_((Property)DISTANCE) : 7;
    }
}

