/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct;

import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.culinaryconstruct.client.CulinaryScreen;
import top.theillusivec4.culinaryconstruct.client.model.FoodBowlLoader;
import top.theillusivec4.culinaryconstruct.client.model.SandwichLoader;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.advancement.CulinaryTriggers;
import top.theillusivec4.culinaryconstruct.common.capability.CapabilityCulinaryFood;
import top.theillusivec4.culinaryconstruct.common.network.CulinaryConstructNetwork;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;

@Mod(value="culinaryconstruct")
public class CulinaryConstruct {
    public static final String MODID = "culinaryconstruct";
    public static final Logger LOGGER = LogManager.getLogger();

    public CulinaryConstruct() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CulinaryConstructConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CulinaryConstructNetwork.register();
        CapabilityCulinaryFood.register();
        CulinaryTriggers.register();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ScreenManager.func_216911_a(CulinaryConstructRegistry.CULINARY_STATION_CONTAINER, CulinaryScreen::new);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MODID, "sandwich_loader"), (IModelLoader)SandwichLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MODID, "food_bowl_loader"), (IModelLoader)FoodBowlLoader.INSTANCE);
    }

    @Mod.EventBusSubscriber(modid="culinaryconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent.Pre evt) {
            AtlasTexture map = evt.getMap();
            if (map.func_229223_g_() == PlayerContainer.field_226615_c_) {
                for (int i = 0; i < 5; ++i) {
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/sandwich/bread" + i));
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/sandwich/layer" + i));
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/bowl/layer" + i));
                }
                evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/bowl/liquid_base"));
                evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/bowl/liquid_overflow"));
            }
        }
    }
}

