/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model.base;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import top.theillusivec4.culinaryconstruct.CulinaryConstruct;
import top.theillusivec4.culinaryconstruct.client.model.utils.ModelHelper;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public abstract class CulinaryOverrideHandler<T extends IModelGeometry<T>>
extends ItemOverrideList {
    protected final T model;
    protected final ModelBakery bakery;
    protected final IModelConfiguration owner;
    protected final Function<Material, TextureAtlasSprite> spriteGetter;
    protected final IModelTransform modelTransform;
    protected final ResourceLocation modelLocation;
    private Cache<ModelHelper.CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public CulinaryOverrideHandler(T model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelLocation = modelLocation;
        this.modelTransform = modelTransform;
    }

    @Nonnull
    public IBakedModel func_209581_a(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        CompoundNBT data = CulinaryNBTHelper.getTagSafe(stack);
        IBakedModel output = originalModel;
        if (!data.isEmpty()) {
            ModelHelper.CacheKey key = this.getCacheKey(originalModel, stack);
            try {
                output = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getBakedModel(originalModel, stack, worldIn, entityIn));
            }
            catch (ExecutionException e) {
                CulinaryConstruct.LOGGER.error("Error baking model!");
            }
        }
        return output;
    }

    protected abstract IBakedModel getBakedModel(IBakedModel var1, ItemStack var2, @Nullable World var3, @Nullable LivingEntity var4);

    ModelHelper.CacheKey getCacheKey(IBakedModel original, ItemStack stack) {
        return new ModelHelper.CacheKey(original, stack);
    }
}

